
package it.unibo.cmdb.cmdbf.client;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordTypeType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.UnsupportedRecordTypeFaultType;

public class UnsupportedRecordTypeException extends Exception{
	private static final long serialVersionUID = -6237665349425141928L;
	protected String localName;
    protected String namespace;
    
    public UnsupportedRecordTypeException(UnsupportedRecordTypeFaultType fault){
    	RecordTypeType recordType = fault.getRecordType();
    	if(recordType != null) {
    		this.localName = recordType.getLocalName();
    		this.namespace = recordType.getNamespace();
    	}
    }

    public String getLocalName() {
        return localName;
    }


    public String getNamespace() {
        return namespace;
    }
}
