/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfFactory;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelElement;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelMetadata;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelRecordType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertySetType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.QNameType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterRequestType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.util.CmdbfEObjectList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Model Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelElementImpl#getRecord <em>Record</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelElementImpl#getInstanceId <em>Instance Id</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelElementImpl#getAdditionalRecordType <em>Additional Record Type</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelElementImpl#getTemplateId <em>Template Id</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelElementImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelElementImpl#isDeregister <em>Deregister</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class ModelElementImpl extends MinimalEObjectImpl.Container implements ModelElement {
	/**
	 * The cached value of the '{@link #getRecord() <em>Record</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecord()
	 * @generated
	 * @ordered
	 */
	protected EList<RecordType> record;

	/**
	 * The cached value of the '{@link #getInstanceId() <em>Instance Id</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstanceId()
	 * @generated
	 * @ordered
	 */
	protected EList<MdrScopedIdType> instanceId;

	/**
	 * The cached value of the '{@link #getAdditionalRecordType() <em>Additional Record Type</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAdditionalRecordType()
	 * @generated
	 * @ordered
	 */
	protected EList<QNameType> additionalRecordType;

	/**
	 * The cached value of the '{@link #getTemplateId() <em>Template Id</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemplateId()
	 * @generated
	 * @ordered
	 */
	protected EList<String> templateId;

	/**
	 * The default value of the '{@link #isDeregister() <em>Deregister</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDeregister()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DEREGISTER_EDEFAULT = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelElementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CmdbfPackage.Literals.MODEL_ELEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public EList<RecordType> getRecord() {
		if (record == null) {
			record = new CmdbfEObjectList<RecordType>(RecordType.class, this, CmdbfPackage.MODEL_ELEMENT__RECORD, CmdbfPackage.RECORD_TYPE__PARENT, CmdbfPackage.RECORD_TYPE__RECORD_ID);
		}
		return record;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MdrScopedIdType> getInstanceId() {
		if (instanceId == null) {
			instanceId = new EObjectContainmentEList<MdrScopedIdType>(MdrScopedIdType.class, this, CmdbfPackage.MODEL_ELEMENT__INSTANCE_ID);
		}
		return instanceId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<QNameType> getAdditionalRecordType() {
		if (additionalRecordType == null) {
			additionalRecordType = new EObjectContainmentEList<QNameType>(QNameType.class, this, CmdbfPackage.MODEL_ELEMENT__ADDITIONAL_RECORD_TYPE);
		}
		return additionalRecordType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getTemplateId() {
		if (templateId == null) {
			templateId = new EDataTypeUniqueEList<String>(String.class, this, CmdbfPackage.MODEL_ELEMENT__TEMPLATE_ID);
		}
		return templateId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RegisterRequestType getParent() {
		InternalEObject container = eInternalContainer();
		while(container!=null && !(container instanceof RegisterRequestType))
			container = container.eInternalContainer();
		return (RegisterRequestType)container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	abstract public boolean isDeregister();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	abstract public void setDeregister(boolean newDeregister);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public MdrScopedIdType findInstanceId() {
		MdrScopedIdType instanceId = null;
		if(getParent() != null)
			instanceId = findInstanceId(getParent().getMdrId());
		if(instanceId == null && !getInstanceId().isEmpty())
			instanceId = getInstanceId().get(0);
		return instanceId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public MdrScopedIdType findInstanceId(String mdrId) {
		MdrScopedIdType instanceId = null;
		if(mdrId != null) {
			Iterator<MdrScopedIdType> iterator = getInstanceId().iterator();
			while(instanceId==null && iterator.hasNext()) {
				MdrScopedIdType id = iterator.next();
				if(mdrId.equals(id.getMdrId()))
					instanceId = id;
			}
		}
		return instanceId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public MdrScopedIdType addInstanceId(String localId) {
		return addInstanceId(getParent().getMdrId());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public MdrScopedIdType addInstanceId(String mdrId, String localId) {
		MdrScopedIdType instanceId = CmdbfFactory.eINSTANCE.createMdrScopedIdType();
		instanceId.setMdrId(mdrId);
		instanceId.setLocalId(localId);
		getInstanceId().add(instanceId);
		return instanceId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public QNameType addAdditionalRecordType(String type) {
		String localName = getModelMetadata().getLocalName(type);
		String namespace = getModelMetadata().getNamespace(type);
		return addAdditionalRecordType(namespace, localName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public QNameType addAdditionalRecordType(String namespace, String localName) {
		QNameType qname = CmdbfFactory.eINSTANCE.createQNameType();
		qname.setNamespace(namespace);
		qname.setLocalName(localName);
		getAdditionalRecordType().add(qname);
		return qname;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType addRecord(String type) {
		String localName = getModelMetadata().getLocalName(type);
		String namespace = getModelMetadata().getNamespace(type);
		return addRecord(namespace, localName, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType addRecord(String namespace, String localName) {
		return addRecord(namespace, localName, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType addRecord(String type, boolean isPropertySet) {
		String localName = getModelMetadata().getLocalName(type);
		String namespace = getModelMetadata().getNamespace(type);
		return addRecord(namespace, localName, isPropertySet);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType addRecord(String namespace, String localName, boolean isPropertySet) {
		RecordType record = CmdbfFactory.eINSTANCE.createRecordType();
		getRecord().add(record);
		if(isPropertySet) {
			PropertySetType propertySet = CmdbfFactory.eINSTANCE.createPropertySetType();
			propertySet.setNamespace(namespace);
			propertySet.setLocalName(localName);
			record.setPropertySet(propertySet);
		}
		else {
			ModelRecordType recordType = getModelMetadata().getRecordType(namespace, localName);
			record.setType(recordType);
		}
		return record;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType findRecord(String type) {
		String localName = getModelMetadata().getLocalName(type);
		String namespace = getModelMetadata().getNamespace(type);
		return findRecordByTemplate(null, namespace, localName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType findRecord(String namespace, String localName) {
		return findRecordByTemplate(null, namespace, localName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType findRecordByTemplate(String templateId, String type) {
		String localName = getModelMetadata().getLocalName(type);
		String namespace = getModelMetadata().getNamespace(type);
		return findRecordByTemplate(templateId, namespace, localName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType findRecordByTemplate(String templateId, String namespace, String localName) {
		RecordType record = null;
		Iterator<RecordType> iterator = getRecord().iterator();
		while(record==null && iterator.hasNext()) {
			RecordType current = iterator.next();
			if(templateId==null || current.getTemplateId().contains(templateId)) {
				boolean match = false;
				
				if(namespace!=null) {
					if(localName != null) {
						ModelRecordType superType = getModelMetadata().getRecordType(namespace, localName);
						if(superType!=null)
							match = current.instanceOf(superType);
					}
					else {
						ModelRecordType type = current.getType();
						match = type!=null ? namespace.equals(type.getNamespace()) : false;
					}
				}
				else
					match = localName==null;
				
				if (match)
					record = current;
			}
		}
		return record;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public RecordType findRecordById(String id) {
		return((CmdbfEObjectList<RecordType>)getRecord()).find(id);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public boolean merge(ModelElement element) {
		boolean modified = false;
		if (element != this) {
			for(MdrScopedIdType elementId : element.getInstanceId()) {
				boolean found = false;
				for(MdrScopedIdType id : getInstanceId()) {
					found |= EcoreUtil.equals(id, elementId);
				}
				if(!found)
					modified |= getInstanceId().add(elementId);
			}
			element.getInstanceId().clear();
			Iterator<RecordType> recordIterator = element.getRecord().iterator();
			while(recordIterator.hasNext()) {
				RecordType elementRecord = recordIterator.next();
				RecordType record = findRecordById(elementRecord.getRecordId());
				if(record != null) {
					modified |= record.merge(elementRecord);
				}
				else {
					recordIterator.remove();
					modified |= getRecord().add(elementRecord);
				}
			}
			
			Iterator<QNameType> typeIterator = element.getAdditionalRecordType().iterator();			
			while(typeIterator.hasNext()) {
				QNameType elementRecordType = typeIterator.next();
				boolean found = false;
				for(QNameType recordType : getAdditionalRecordType()) {
					found |= EcoreUtil.equals(recordType, elementRecordType);
				}
				if(!found) {
					typeIterator.remove();
					modified |= getAdditionalRecordType().add(elementRecordType);
				}
			}
			
			for(String elementTemplateId : element.getTemplateId()) {
				boolean found = false;
				for(String templateId : getTemplateId()) {
					found |= templateId.equals(elementTemplateId);
				}
				if(!found)
					modified |= getTemplateId().add(elementTemplateId);
			}			
		}
		return modified;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.MODEL_ELEMENT__RECORD:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRecord()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CmdbfPackage.MODEL_ELEMENT__RECORD:
				return ((InternalEList<?>)getRecord()).basicRemove(otherEnd, msgs);
			case CmdbfPackage.MODEL_ELEMENT__INSTANCE_ID:
				return ((InternalEList<?>)getInstanceId()).basicRemove(otherEnd, msgs);
			case CmdbfPackage.MODEL_ELEMENT__ADDITIONAL_RECORD_TYPE:
				return ((InternalEList<?>)getAdditionalRecordType()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CmdbfPackage.MODEL_ELEMENT__RECORD:
				return getRecord();
			case CmdbfPackage.MODEL_ELEMENT__INSTANCE_ID:
				return getInstanceId();
			case CmdbfPackage.MODEL_ELEMENT__ADDITIONAL_RECORD_TYPE:
				return getAdditionalRecordType();
			case CmdbfPackage.MODEL_ELEMENT__TEMPLATE_ID:
				return getTemplateId();
			case CmdbfPackage.MODEL_ELEMENT__PARENT:
				return getParent();
			case CmdbfPackage.MODEL_ELEMENT__DEREGISTER:
				return isDeregister();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CmdbfPackage.MODEL_ELEMENT__RECORD:
				getRecord().clear();
				getRecord().addAll((Collection<? extends RecordType>)newValue);
				return;
			case CmdbfPackage.MODEL_ELEMENT__INSTANCE_ID:
				getInstanceId().clear();
				getInstanceId().addAll((Collection<? extends MdrScopedIdType>)newValue);
				return;
			case CmdbfPackage.MODEL_ELEMENT__ADDITIONAL_RECORD_TYPE:
				getAdditionalRecordType().clear();
				getAdditionalRecordType().addAll((Collection<? extends QNameType>)newValue);
				return;
			case CmdbfPackage.MODEL_ELEMENT__TEMPLATE_ID:
				getTemplateId().clear();
				getTemplateId().addAll((Collection<? extends String>)newValue);
				return;
			case CmdbfPackage.MODEL_ELEMENT__DEREGISTER:
				setDeregister((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CmdbfPackage.MODEL_ELEMENT__RECORD:
				getRecord().clear();
				return;
			case CmdbfPackage.MODEL_ELEMENT__INSTANCE_ID:
				getInstanceId().clear();
				return;
			case CmdbfPackage.MODEL_ELEMENT__ADDITIONAL_RECORD_TYPE:
				getAdditionalRecordType().clear();
				return;
			case CmdbfPackage.MODEL_ELEMENT__TEMPLATE_ID:
				getTemplateId().clear();
				return;
			case CmdbfPackage.MODEL_ELEMENT__DEREGISTER:
				setDeregister(DEREGISTER_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CmdbfPackage.MODEL_ELEMENT__RECORD:
				return record != null && !record.isEmpty();
			case CmdbfPackage.MODEL_ELEMENT__INSTANCE_ID:
				return instanceId != null && !instanceId.isEmpty();
			case CmdbfPackage.MODEL_ELEMENT__ADDITIONAL_RECORD_TYPE:
				return additionalRecordType != null && !additionalRecordType.isEmpty();
			case CmdbfPackage.MODEL_ELEMENT__TEMPLATE_ID:
				return templateId != null && !templateId.isEmpty();
			case CmdbfPackage.MODEL_ELEMENT__PARENT:
				return getParent() != null;
			case CmdbfPackage.MODEL_ELEMENT__DEREGISTER:
				return isDeregister() != DEREGISTER_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case CmdbfPackage.MODEL_ELEMENT___FIND_INSTANCE_ID:
				return findInstanceId();
			case CmdbfPackage.MODEL_ELEMENT___FIND_INSTANCE_ID__STRING:
				return findInstanceId((String)arguments.get(0));
			case CmdbfPackage.MODEL_ELEMENT___ADD_INSTANCE_ID__STRING:
				return addInstanceId((String)arguments.get(0));
			case CmdbfPackage.MODEL_ELEMENT___ADD_INSTANCE_ID__STRING_STRING:
				return addInstanceId((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.MODEL_ELEMENT___ADD_ADDITIONAL_RECORD_TYPE__STRING:
				return addAdditionalRecordType((String)arguments.get(0));
			case CmdbfPackage.MODEL_ELEMENT___ADD_ADDITIONAL_RECORD_TYPE__STRING_STRING:
				return addAdditionalRecordType((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.MODEL_ELEMENT___ADD_RECORD__STRING:
				return addRecord((String)arguments.get(0));
			case CmdbfPackage.MODEL_ELEMENT___ADD_RECORD__STRING_STRING:
				return addRecord((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.MODEL_ELEMENT___ADD_RECORD__STRING_BOOLEAN:
				return addRecord((String)arguments.get(0), (Boolean)arguments.get(1));
			case CmdbfPackage.MODEL_ELEMENT___ADD_RECORD__STRING_STRING_BOOLEAN:
				return addRecord((String)arguments.get(0), (String)arguments.get(1), (Boolean)arguments.get(2));
			case CmdbfPackage.MODEL_ELEMENT___FIND_RECORD__STRING:
				return findRecord((String)arguments.get(0));
			case CmdbfPackage.MODEL_ELEMENT___FIND_RECORD__STRING_STRING:
				return findRecord((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.MODEL_ELEMENT___FIND_RECORD_BY_TEMPLATE__STRING_STRING:
				return findRecordByTemplate((String)arguments.get(0), (String)arguments.get(1));
			case CmdbfPackage.MODEL_ELEMENT___FIND_RECORD_BY_TEMPLATE__STRING_STRING_STRING:
				return findRecordByTemplate((String)arguments.get(0), (String)arguments.get(1), (String)arguments.get(2));
			case CmdbfPackage.MODEL_ELEMENT___FIND_RECORD_BY_ID__STRING:
				return findRecordById((String)arguments.get(0));
			case CmdbfPackage.MODEL_ELEMENT___MERGE__MODELELEMENT:
				return merge((ModelElement)arguments.get(0));
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(/* super.toString() */);
		String mdrId = getParent()!=null ? getParent().getMdrId() : null;		
		result.append(" (instanceId: ");
		MdrScopedIdType instanceId = findInstanceId();
		if(instanceId != null) {
			if(mdrId==null || !mdrId.equals(instanceId.getMdrId()))
				result.append(instanceId.toString());
			else
				result.append(instanceId.getLocalId());
		}
		result.append(" ,records: ");
		for(RecordType record : getRecord())
			result.append(record.toString());
		//result.append(" ,templateId: ");
		//result.append(templateId);
		//result.append(", deregister: ");
		//result.append(deregister);
		result.append(')');
		return result.toString();
	}
	
	@Override
	public boolean equals(final Object obj) {
		boolean equals = false;
		if (obj instanceof ModelElement) {
			final ModelElement element = (ModelElement) obj;
			final Iterator<MdrScopedIdType> objIdIterator = element.getInstanceId().iterator();
			while (!equals && objIdIterator.hasNext()) {
				Iterator<MdrScopedIdType> idIterator = getInstanceId().iterator();
				while (!equals && idIterator.hasNext())								
					equals = objIdIterator.next().equals(idIterator.next());
			}
		}
		return equals;
	}
		
	private ModelMetadata getModelMetadata(){
		return getParent().getParent().getModelMetadata();
	}
} //ModelElementImpl
