/**
 */
package it.unibo.cmdb.cmdbf.client.model.cmdbf.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.dmtf.schemas.cmdbf._1.tns.servicemetadata.QNameType;
import org.dmtf.schemas.cmdbf._1.tns.servicemetadata.RecordTypeList;
import org.dmtf.schemas.cmdbf._1.tns.servicemetadata.RecordTypes;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave.XMLTypeInfo;
import org.eclipse.emf.ecore.xmi.util.XMLProcessor;
import org.xml.sax.SAXException;

import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfFactory;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.CmdbfPackage;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelMetadata;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelRecordType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.impl.ModelMetadataImpl;

/**
 * This class contains helper methods to serialize and deserialize XML documents
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CmdbfXMLProcessor extends XMLProcessor {
	
	private ModelMetadata modelMetadata;
	private Map<String, String> prefixes = new ConcurrentHashMap<String, String>();
	private Map<String, Map<String, ModelRecordType>> recordTypes;

	/**
	 * Public constructor to instantiate the helper.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public CmdbfXMLProcessor() throws SAXException {
		super((EPackage.Registry.INSTANCE));
		CmdbfPackage.eINSTANCE.eClass();
		
		loadOptions.put(XMLResource.OPTION_USE_ENCODED_ATTRIBUTE_STYLE, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_USE_LEXICAL_HANDLER, Boolean.TRUE);
		saveOptions.put(XMLResource.OPTION_USE_ENCODED_ATTRIBUTE_STYLE, Boolean.TRUE); 
		saveOptions.put(XMLResource.OPTION_SCHEMA_LOCATION, Boolean.TRUE);
		
		saveOptions.put(XMLResource.OPTION_DECLARE_XML, Boolean.FALSE);
		saveOptions.put(XMLResource.OPTION_FORMATTED, Boolean.TRUE);
		saveOptions.put(XMLResource.OPTION_ENCODING, "UTF-8");
	    loadOptions.put(XMLResource.OPTION_ENCODING, "UTF-8");
	    
	    XMLTypeInfo xmlTypeInfo = new XMLTypeInfo() {

			@Override
			public boolean shouldSaveType(EClass objectType, EClassifier featureType, EStructuralFeature feature) {
				return false;
			}

			@Override
			public boolean shouldSaveType(EClass objectType, EClass featureType, EStructuralFeature feature) {
				return true;
			}	    	
	    };
	    
		saveOptions.put(XMLResource.OPTION_SAVE_TYPE_INFORMATION, xmlTypeInfo);
	    
	    CmdbfResourceHandler resourceHandler = new CmdbfResourceHandler(getExtendedMetaData(), getModelMetadata());
		saveOptions.put(XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE);
		saveOptions.put(XMLResource.OPTION_RESOURCE_HANDLER, resourceHandler);
		loadOptions.put(XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_RESOURCE_HANDLER, resourceHandler);
	}
	
	/**
	 * Register for "*" and "xml" file extensions the CmdbfResourceFactoryImpl factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected Map<String, Resource.Factory> getRegistrations() {
		if (registrations == null) {
			super.getRegistrations();
			registrations.put(XML_EXTENSION, new CmdbfResourceFactoryImpl());
			registrations.put(STAR_EXTENSION, new CmdbfResourceFactoryImpl());
		}
		return registrations;
	}
	
	public void addPrefix(String prefix, String namespace) {
		prefixes.put(prefix, namespace);
	}
		
	public ModelMetadata getModelMetadata() {
		if(modelMetadata == null) {
			modelMetadata = new ModelMetadataImpl() {
								
				@Override
				public EStructuralFeature getElement(String namespace, String localName) {
					EStructuralFeature feature = null;
					Object value = getExtendedMetaData();
					if(value != null && value instanceof ExtendedMetaData) {
						ExtendedMetaData extendedMetaData = (ExtendedMetaData)value;
						feature = extendedMetaData.getElement(namespace, localName);
					}
					return feature;
				}

				@Override
				public String getNamespace(EClassifier classifier) {
					String namespace = null;	
					Object value = getExtendedMetaData();
					if(value != null && value instanceof ExtendedMetaData) {
						ExtendedMetaData extendedMetaData = (ExtendedMetaData)value;
						namespace = extendedMetaData.getNamespace(classifier);
					}
					return namespace;
				}

				@Override
				public String getLocalName(EClassifier classifier) {
					String name = null;	
					Object value = getExtendedMetaData();
					if(value != null && value instanceof ExtendedMetaData) {
						ExtendedMetaData extendedMetaData = (ExtendedMetaData)value;
						name = extendedMetaData.getName(classifier);
					}
					return name;
				}

				@Override
				public ModelRecordType getRecordType(String namespace, String localName) {
					ModelRecordType type = null;
					if(recordTypes != null) {
						Map<String, ModelRecordType> map = recordTypes.get(namespace);
						if(map != null)
							type = map.get(localName);
					}
					return type;
				}

				@Override
				public String getNamespace(String name) {
					String namespace = null;
					int pos = name.indexOf(':');
					String prefix = pos>=0 ? name.substring(0, pos) : null;
					namespace = prefixes.get(prefix);
					return namespace;
				}

				@Override
				public String getLocalName(String name) {
					int pos = name.indexOf(':');
					return pos>=0 ? name.substring(pos+1) : name;
				}
			};
		}
		return modelMetadata;
	}
		
	public void parseRecordTypeList(RecordTypeList recordTypeList) throws Exception {
		Collection<URI> schemaLocations = new HashSet<URI>();
		Map<String, Map<String, ModelRecordType>> types = new HashMap<String, Map<String, ModelRecordType>>();
		for(RecordTypes recordTypes : recordTypeList.getRecordTypes()) {
			schemaLocations.add(URI.createURI(recordTypes.getSchemaLocation()));
			Map<String, ModelRecordType> typeMap = types.get(recordTypes.getNamespace());
			if(typeMap == null) {
				typeMap = new HashMap<String, ModelRecordType>();
				types.put(recordTypes.getNamespace(), typeMap);
			}			
			for(org.dmtf.schemas.cmdbf._1.tns.servicemetadata.RecordType recordType: recordTypes.getRecordType()){
				ModelRecordType modelRecordType = CmdbfFactory.eINSTANCE.createModelRecordType();
				modelRecordType.setNamespace(recordTypes.getNamespace());
				modelRecordType.setLocalName(recordType.getLocalName());
				if("item".equals(recordType.getAppliesTo()))
					modelRecordType.setAppliesToItem(true);
				else if("relationship".equals(recordType.getAppliesTo()))
					modelRecordType.setAppliesToRelationship(true);
				else if("both".equals(recordType.getAppliesTo())) {
					modelRecordType.setAppliesToItem(true);
					modelRecordType.setAppliesToRelationship(true);
				}
				typeMap.put(recordType.getLocalName(), modelRecordType);
			}
			
			for(org.dmtf.schemas.cmdbf._1.tns.servicemetadata.RecordType recordType: recordTypes.getRecordType()){
				ModelRecordType modelRecordType = typeMap.get(recordType.getLocalName());
				for(QNameType superType : recordType.getSuperType()) {
					ModelRecordType modelSuperType = typeMap.get(superType.getLocalName());
					modelRecordType.getSuperType().add(modelSuperType);
				}
			}
		}
		if(recordTypes == null) {
			recordTypes = types;
			addSchemaLocations(schemaLocations);
		}
	}
	
	private void addSchemaLocations(Collection<URI> schemaURIs) throws Exception {
		for (Resource resource : ecoreBuilder.generate(schemaURIs)) {
			for (EPackage ePackage : EcoreUtil.<EPackage>getObjectsByType(resource.getContents(), EcorePackage.Literals.EPACKAGE))
				EcoreUtil.freeze(ePackage);
		}
	}

} //CmdbfXMLProcessor
