import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Iterator;

import javax.swing.JFrame;
import javax.swing.SwingConstants;
import javax.xml.namespace.QName;

import org.cmdbuild.cmdbf.client.graph.CmdbfGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.JGraphXAdapter;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.swing.mxGraphComponent;

import it.unibo.cmdb.cmdbf.client.CMDBClient;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemTemplateType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ItemType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.MdrScopedIdType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.Model;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.ModelUpdateResponse;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.PropertyValueType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.QueryType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordConstraintType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RecordType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RegisterInstanceResponseType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipTemplateType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.RelationshipType;
import it.unibo.cmdb.cmdbf.client.model.cmdbf.SelectedRecordTypeType;

public class Test {

	public static void main(String[] args) throws Exception {
		String host = "http://localhost:8080";
		QName queryService = new QName("http://schemas.dmtf.org/cmdbf/1/tns/query", "CMDBfQueryImplService");
		QName queryPortName = new QName("http://schemas.dmtf.org/cmdbf/1/tns/query", "CMDBfQueryImplPort");
		URL queryWSDL = new URL(host + "/cmdbuild/services/soap/CMDBfQuery?wsdl");
	    QName registrationService = new QName("http://schemas.dmtf.org/cmdbf/1/tns/registration", "CMDBfRegistrationImplService");
	    QName registrationPortName = new QName("http://schemas.dmtf.org/cmdbf/1/tns/registration", "CMDBfRegistrationImplPort");
	    URL registrationWSDL = new URL(host + "/cmdbuild/services/soap/CMDBfRegistration?wsdl");
		CMDBClient client = new CMDBClient(queryWSDL, queryService, queryPortName, registrationWSDL, registrationService, registrationPortName, "admin", "admin");
		client.addPrefix("class", "http://www.cmdbuild.org/class");
		client.addPrefix("domain", "http://www.cmdbuild.org/domain");
		
		test6(client);
	}
	
	public static void test6(CMDBClient client) throws Exception {
		String cmdbSource = "SCCM";
		String query = "<cmdb:query xmlns:cmdb=\"http://schemas.dmtf.org/cmdbf/1/tns/serviceData\">" +
				" <cmdb:itemTemplate id=\"item\">" +
				"  <cmdb:recordConstraint>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"ManagedClientDevice\"/>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"LINK_IF\"/>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"NET_IF\"/>" +
				"   <cmdb:propertyValue namespace=\"http://www.cmdbuild.org/class\" localName=\"CmdbSource\">" +
				"    <cmdb:equal>" + cmdbSource + "</cmdb:equal>" +
				"   </cmdb:propertyValue>" +
				"  </cmdb:recordConstraint>" +
				" </cmdb:itemTemplate>" +
				" <cmdb:itemTemplate id=\"systemSoftwareType\">" +
				"  <cmdb:recordConstraint>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"SystemSoftwareType\"/>" +
				"  </cmdb:recordConstraint>" +
				" </cmdb:itemTemplate>" +   
				" <cmdb:itemTemplate id=\"systemSoftwareTypeItem\" suppressFromResult=\"true\">" +
				"  <cmdb:recordConstraint>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"ManagedClientDevice\"/>" +
				"   <cmdb:propertyValue namespace=\"http://www.cmdbuild.org/class\" localName=\"CmdbSource\">" +
				"    <cmdb:equal>" + cmdbSource + "</cmdb:equal>" +
				"   </cmdb:propertyValue>" +
				"  </cmdb:recordConstraint>" +
				" </cmdb:itemTemplate>" +
				" <cmdb:relationshipTemplate id=\"systemSoftwareTypeRelationship\" suppressFromResult=\"true\">" +
				"  <cmdb:sourceTemplate ref=\"systemSoftwareType\"/>" +
				"  <cmdb:targetTemplate ref=\"systemSoftwareTypeItem\"/>" +
				"  <cmdb:recordConstraint>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"SystemSoftwareTypeClientDevice\"/>" +
				"  </cmdb:recordConstraint>" +
				" </cmdb:relationshipTemplate>" +
				" <cmdb:itemTemplate id=\"anagrafica\" suppressFromResult=\"true\">" +
				"  <cmdb:recordConstraint>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"Anagrafica\"/>" +
				"  </cmdb:recordConstraint>" +
				" </cmdb:itemTemplate>" +   
				" <cmdb:itemTemplate id=\"managedClientDevice\" suppressFromResult=\"true\">" +
				"  <cmdb:recordConstraint>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/class\" localName=\"ManagedClientDevice\"/>" +
				"   <cmdb:propertyValue namespace=\"http://www.cmdbuild.org/class\" localName=\"CmdbSource\">" +
				"    <cmdb:equal>" + cmdbSource + "</cmdb:equal>" +
				"   </cmdb:propertyValue>" +
				"  </cmdb:recordConstraint>" +
				" </cmdb:itemTemplate>" +
				" <cmdb:relationshipTemplate id=\"utilizzatoreClientDevice\" >" +
				"  <cmdb:sourceTemplate ref=\"anagrafica\"/>" +
				"  <cmdb:targetTemplate ref=\"managedClientDevice\"/>" +
				"  <cmdb:recordConstraint>" +
				"   <cmdb:recordType namespace=\"http://www.cmdbuild.org/domain\" localName=\"UtilizzatoreClientDevice\"/>" +
				"  </cmdb:recordConstraint>" +
				" </cmdb:relationshipTemplate>" +
				"</cmdb:query>";
		Model model = client.query(query);
		client.save(model, System.out);
		System.out.println();
	}
	
	public static void test5(CMDBClient client) throws Exception {
		Model newModel = client.newModel();
		ItemType newItem = newModel.addItem();
		RecordType newRecord = newItem.addRecord("class:SERVER_DEV");
		newRecord.set("code", "Test");		
		
		QueryType query = client.newQuery();
		
		ItemTemplateType server1 = query.addItemTemplate("Server1");
		RecordConstraintType serverConstraint1 = server1.addRecordConstraint();
		serverConstraint1.addRecordType("class:SERVER_DEV");
		serverConstraint1.addPropertyValue("class:Code").addLike("TWeb%");
		SelectedRecordTypeType serverSelector1 = server1.addContentSelector("class:SERVER_DEV");
		serverSelector1.addSelectedProperty("class:Code");
		serverSelector1.addSelectedProperty("class:Cpu");
		serverSelector1.addSelectedProperty("class:Ram");
		
		ItemTemplateType server2 = query.addItemTemplate("Server2");
		RecordConstraintType serverConstraint2 = server2.addRecordConstraint();
		serverConstraint2.addRecordType("class:SERVER_DEV");
		serverConstraint2.addPropertyValue("class:Code").addLike("TWeb%");
		SelectedRecordTypeType serverSelector2 = server2.addContentSelector("class:SERVER_DEV");
		serverSelector2.addSelectedProperty("class:Code");
		serverSelector2.addSelectedProperty("class:OperatingSystem");
		serverSelector2.addSelectedProperty("class:Type");
		
		ItemTemplateType infrastructureInterface1 = query.addItemTemplate("InfrastructureInterface1");
		RecordConstraintType infrastructureInterfaceRecordConstraint1 = infrastructureInterface1.addRecordConstraint();
		infrastructureInterfaceRecordConstraint1.addRecordType("class:LINK_IF");
		infrastructureInterfaceRecordConstraint1.addRecordType("class:NET_IF");
		
		ItemTemplateType infrastructureInterface2 = query.addItemTemplate("InfrastructureInterface2");
		RecordConstraintType infrastructureInterfaceRecordConstraint2 = infrastructureInterface2.addRecordConstraint(); 
		infrastructureInterfaceRecordConstraint2.addRecordType("class:LINK_IF");	
		infrastructureInterfaceRecordConstraint2.addRecordType("class:NET_IF");
		
		RelationshipTemplateType interfaceComposition1 = query.addRelationshipTemplate("InterfaceComposition1");
		interfaceComposition1.addRecordConstraint().addRecordType("domain:NodeInfInterfaceComposition");
		interfaceComposition1.addSourceTemplate(server1);
		interfaceComposition1.addTargetTemplate(infrastructureInterface1);
		
		RelationshipTemplateType interfaceComposition2 = query.addRelationshipTemplate("InterfaceComposition2");
		interfaceComposition2.addRecordConstraint().addRecordType("domain:NodeInfInterfaceComposition");
		interfaceComposition2.addSourceTemplate(server2);
		interfaceComposition2.addTargetTemplate(infrastructureInterface2);
		
		Model baseModel = client.query(query);
		Model model = client.query(query);
		model.getItemByTemplate("Server1").get(0).getRecord().get(0).set("description", "test model diff");
		
		ItemType item = model.getItemByTemplate("Server1").get(1);
		Iterator<RelationshipType> sourceRelationshipterator = item.getRelationshipBySource().iterator();
		while(sourceRelationshipterator.hasNext()) {
			RelationshipType relationship = sourceRelationshipterator.next();
			sourceRelationshipterator.remove();
			relationship.setSourceItem(null);
			relationship.setTargetItem(null);
			model.getRelationship().remove(relationship);			
		}
		Iterator<RelationshipType> targetRelationshipterator = item.getRelationshipByTarget().iterator();
		while(sourceRelationshipterator.hasNext()) {
			RelationshipType relationship = targetRelationshipterator.next();
			targetRelationshipterator.remove();
			relationship.setSourceItem(null);
			relationship.setTargetItem(null);
			model.getRelationship().remove(relationship);			
		}
		model.getItem().remove(item);
		
		System.out.println("BASE MODEL:");
		client.save(baseModel, System.out);
		System.out.println();
		
		System.out.println("MODEL:");		
		client.save(model, System.out);
		System.out.println();
		
		Model diffModel = client.diff(model, baseModel);
		System.out.println("DIFF:");		
		client.save(diffModel, System.out);
		System.out.println();
		
		ByteArrayOutputStream outStream = new ByteArrayOutputStream();
		client.save(baseModel, outStream);
		ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
		baseModel = client.load(inStream);
        		
		show(baseModel);
	}
	
	public static void test4(CMDBClient client) throws Exception {
		Model model = null;
		ItemType newItem = null;
		RecordType newRecord = null;
		ModelUpdateResponse response = null;
		
		// REGISTER ITEMS
		model = client.newModel();
		newItem = model.addItem();
		newItem.addInstanceId("http://schema.unibo.it/test/cmdbf-client/201404221058", "Test01");
		newItem.addInstanceId("http://schema.unibo.it/test/cmdbf-client/201404221058-1", "Test01");
		newRecord = newItem.addRecord("class:SystemSoftwareType");
		newRecord.set("code", "test01");
		newRecord.set("description", "test 01");
		newItem = model.addItem();
		newItem.addInstanceId("http://schema.unibo.it/test/cmdbf-client/201404221058", "Test01");
		newItem.addInstanceId("http://schema.unibo.it/test/cmdbf-client/201404221058-2", "Test01");		
		newRecord = newItem.addRecord("class:SystemSoftwareType");
		newRecord.set("code", "test02");
		response = client.update(model);
		System.out.println(response);

	}
	
	public static void test3(CMDBClient client) throws Exception {
		Model model = null;
		ItemType newItem = null;
		RecordType newRecord = null;
		ModelUpdateResponse response = null;
		
		// REGISTER ITEMS
		model = client.newModel();
		newItem = model.addItem();
		newItem.addInstanceId("http://schema.unibo.it/test/cmdbf-client/2018041132", "Test01");
		newRecord = newItem.addRecord("class:SystemSoftwareType");
		newRecord.set("code", "test01");
		newRecord.set("description", "test 01");
		newItem = model.addItem();
		newItem.addInstanceId("http://schema.unibo.it/test/cmdbf-client/2018041132", "Test02");
		newRecord = newItem.addRecord("class:GenericSystemSoftware");
		newRecord.set("code", "test02");
		newRecord.setAsString("description", "test 02");
		newRecord.set("type.mdrId", "http://schema.unibo.it/test/cmdbf-client/2018041132");		
		newRecord.set("type.localId", "Test01");
		response = client.update(model);
		System.out.println(response);
		
		QueryType query = client.newQuery();
		ItemTemplateType building = query.addItemTemplate("GenericSystemSoftware");
		RecordConstraintType recordConstraint = building.addRecordConstraint();
		recordConstraint.addRecordType("class:GenericSystemSoftware");
		PropertyValueType propertyValue = recordConstraint.addPropertyValue("class:Code");
		propertyValue.addEqual("test02");
		Model queryModel = client.query(query);
		System.out.println(queryModel.getItem().get(0).getRecord().get(0).getAsString("code"));
		System.out.println(queryModel.getItem().get(0).getRecord().get(0).isSet("type.mdrId"));
		System.out.println(queryModel.getItem().get(0).getRecord().get(0).getAsString("type.localId"));
		System.out.println(queryModel.toString());
		

	}
	
	public static void test2(CMDBClient client) throws Exception {
		Model model = null;
		ItemType newItem = null;
		RecordType newRecord = null;
		ItemType newItem1 = null;
		RecordType newRecord1 = null;
		ItemType newItem2 = null;
		RecordType newRecord2 = null;
		RelationshipType newRelationship = null;
		ModelUpdateResponse response = null;
		MdrScopedIdType itemId = null;
		
		// REGISTER ITEM
		model = client.newModel();
		newItem = model.addItem();
		newItem.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test02");
		newRecord = newItem.addRecord("class:Location");
		newRecord.set("code", "test01");
		newRecord.set("description", "test 02");
		response = client.update(model);
		System.out.println(response);
		itemId = ((RegisterInstanceResponseType)response.getInstanceResponse().get(0)).getAccepted().getAlternateInstanceId().get(0);
		
		// DEREGISTER ITEM
		model = client.newModel();
		newItem = model.addItem();
		newItem.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test02");
		model.remove(newItem);
		response = client.update(model);
		System.out.println(response);
		
		// REGISTER DELETED ITEM
		model = client.newModel();
		newItem = model.addItem();
		newItem.addInstanceId(itemId.getMdrId(), itemId.getLocalId());
		newRecord = newItem.addRecord("class:Location");
		newRecord.set("code", "test03");
		newRecord.set("description", "test 03");
		response = client.update(model);
		System.out.println(response);

		// DEREGISTER DELETED ITEM
		model = client.newModel();
		newItem = model.addItem();
		newItem.addInstanceId(itemId.getMdrId(), itemId.getLocalId());
		model.remove(newItem);
		response = client.update(model);
		System.out.println(response);		
		
		// REGISTER RELATIONSHIP
		model = client.newModel();
		newItem1 = model.addItem();
		newItem1.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test31");
		newRecord1 = newItem1.addRecord("class:Location");
		newRecord1.set("code", "test31");
		newRecord1.set("description", "test 31");
		newItem2 = model.addItem();
		newItem2.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test32");		
		newRecord2 = newItem2.addRecord("class:Location");
		newRecord2.set("code", "test32");
		newRecord2.set("description", "test 32");
		newRelationship = model.addRelationship();
		newRelationship.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test33");
		newRelationship.setSourceItem(newItem1);
		newRelationship.setTargetItem(newItem2);
		newRelationship.addRecord("domain:AssociationRelationship");
		System.out.println(client.update(model));
		
		// DEREGISTER RELATIONSHIP
		model = client.newModel();
		newRelationship = model.addRelationship();
		newRelationship.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test33");
		model.remove(newRelationship);
		System.out.println(client.update(model));
		
		// REGISTER DELETED RELATIONSHIP
		model = client.newModel();
		newItem1 = model.addItem();
		newItem1.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test31");
		newItem2 = model.addItem();
		newItem2.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test32");				
		newRelationship = model.addRelationship();		
		newRelationship.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test33");
		newRelationship.setSourceItem(newItem1);
		newRelationship.setTargetItem(newItem2);		
		newRelationship.addRecord("domain:AssociationRelationship");
		System.out.println(client.update(model));
		
		// REGISTER DELETED RELATIONSHIP FROM SOURCE/TARGET
		model = client.newModel();
		newItem1 = model.addItem();
		newItem1.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test31");
		newItem2 = model.addItem();
		newItem2.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test32");		
		newRelationship = model.addRelationship();
		newRelationship.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "NEWID-20140408094450");
		newRelationship.setSourceItem(newItem1);
		newRelationship.setTargetItem(newItem2);
		newRelationship.addRecord("domain:AssociationRelationship");
		System.out.println(client.update(model));
		
		// DEREGISTER SOURCE AND TARGET ITEMS
		model = client.newModel();
		newItem1 = model.addItem();
		newItem1.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test31");
		model.remove(newItem1);
		newItem2 = model.addItem();
		newItem2.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test32");
		model.remove(newItem2);
		System.out.println(client.update(model));

		// REGISTER DELETED RELATIONSHIP WITH DELETED SOURCE/TARGET
		model = client.newModel();
		newItem1 = model.addItem();
		newItem1.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test31");
		newItem2 = model.addItem();
		newItem2.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test32");		
		newRelationship = model.addRelationship();
		newRelationship.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test33");
		newRelationship.setSourceItem(newItem1);
		newRelationship.setTargetItem(newItem2);		
		newRelationship.addRecord("domain:AssociationRelationship");
		System.out.println(client.update(model));

		// REGISTER DELETED RELATIONSHIP WITH DELETED SOURCE/TARGET FROM SOURCE/TARGET
		model = client.newModel();
		newItem1 = model.addItem();
		newItem1.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test31");
		newItem2 = model.addItem();
		newItem2.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test32");		
		newRelationship = model.addRelationship();
		newRelationship.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "NEWID-33");
		newRelationship.setSourceItem(newItem1);
		newRelationship.setTargetItem(newItem2);
		newRelationship.addRecord("domain:AssociationRelationship");
		System.out.println(client.update(model));	
	
		// DEREGISTER DELETED REATIONSHIP
		model = client.newModel();
		newRelationship = model.addRelationship();
		newRelationship.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140407", "Test33");
		model.remove(newRelationship);
		System.out.println(client.update(model));
	}

	
	public static void test1(CMDBClient client) throws Exception {
		QueryType query = client.newQuery();
		ItemTemplateType building = query.addItemTemplate("Building");
		building.addRecordConstraint().addRecordType("class:Building");
		building.addContentSelector("class:Building").addSelectedProperty("class:Code");

		ItemTemplateType floor = query.addItemTemplate("Floor");
		floor.addRecordConstraint().addRecordType("class:Floor");
		RelationshipTemplateType buildingFloor = query.addRelationshipTemplate("BuildingFloor");
		buildingFloor.addSourceTemplate(building);
		buildingFloor.addTargetTemplate(floor);
		
		Model model = client.query(query);
		System.out.println(model.toString());
		show(model);

		for(ItemType item : model.getItemByTemplate("Building")) {
			System.out.print(item.findInstanceId());
			System.out.print(": ");
			RecordType record = item.findRecord("class:Class");
			if(record != null) {
				System.out.print(record.toString());
				System.out.print(" ");
				System.out.print(record.get("code"));
				record.set("notes", "CMDBf Test");
			}
			System.out.println();
		}
		

		for(ItemType item : model.getItemByTemplate("Floor")) {
			System.out.print(item.findInstanceId());
			System.out.print(": ");
			RecordType record = item.findRecord("class:Floor");
			if(record != null) {
				System.out.print(record.toString());
				System.out.print(" ");
				System.out.print(record.get("code"));
				record.set("notes", "CMDBf Test");
			}
			System.out.println();
		}
		
		ItemType newBuilding = model.addItem();
		newBuilding.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140216", "Test NewBuilding");
		RecordType newBuildingRecord = newBuilding.addRecord("class:Building");
		newBuildingRecord.set("code", "CMDBf Building");		

		ItemType newFloor = model.addItem();
		newFloor.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140216", "Test NewFloor");
		RecordType newFloorRecord = newFloor.addRecord("class:Floor");
		newFloorRecord.set("code", "CMDBf Floor");
		
		RelationshipType newBuildingFloor = model.addRelationship();
		newBuildingFloor.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140216", "Test NewBuildingFloor");
		newBuildingFloor.addRecord("domain:BuildingFloor");
		newBuildingFloor.setSourceItem(newBuilding);
		newBuildingFloor.setTargetItem(newFloor);

		ModelUpdateResponse response = client.update(model);
		System.out.println(response.toString());
				
		model = client.query(query);
		System.out.println(model.toString());
		show(model);
		
		model = client.newModel();
		
		newBuilding = model.addItem();
		newBuilding.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140216", "Test NewBuilding");
		model.remove(newBuilding);
		
		newFloor = model.addItem();
		newFloor.addInstanceId("http://schema.unibo.it/test/cmdbf-client/20140216", "Test NewFloor");
		model.remove(newFloor);
		
		response = client.update(model);
		System.out.println(response.toString());			
		
		model = client.query(query);		
		System.out.println(model.toString());
		show(model);
		show(model);
	}
	
	private static void show(Model model) {
		JFrame frame = new JFrame(model.getMdrId());
        frame.setBounds(50, 50, 850, 640);
        
	    Graph<ItemType, RelationshipType> graph = new CmdbfGraph(model);
		JGraphXAdapter<ItemType, RelationshipType> graphAdapter = new JGraphXAdapter<ItemType, RelationshipType>(graph);
		mxGraphComponent graphComponent = new mxGraphComponent(graphAdapter);
		graphComponent.setSize(800, 600);
		frame.getContentPane().add(graphComponent);
		mxGraphLayout layout = new com.mxgraph.layout.hierarchical.mxHierarchicalLayout(graphAdapter, SwingConstants.WEST);
		layout.execute(graphAdapter.getDefaultParent());
		
        frame.pack();
        frame.setVisible(true);
	}
}
