/**
 */
package it.unibo.cmdb.monitoring.model.icinga.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import it.unibo.cmdb.monitoring.model.icinga.CheckCommand;
import it.unibo.cmdb.monitoring.model.icinga.Checkable;
import it.unibo.cmdb.monitoring.model.icinga.Dependency;
import it.unibo.cmdb.monitoring.model.icinga.Endpoint;
import it.unibo.cmdb.monitoring.model.icinga.EventCommand;
import it.unibo.cmdb.monitoring.model.icinga.Host;
import it.unibo.cmdb.monitoring.model.icinga.IcingaPackage;
import it.unibo.cmdb.monitoring.model.icinga.Notification;
import it.unibo.cmdb.monitoring.model.icinga.ScheduledDowntime;
import it.unibo.cmdb.monitoring.model.icinga.Service;
import it.unibo.cmdb.monitoring.model.icinga.ServiceGroup;
import it.unibo.cmdb.monitoring.model.icinga.TimePeriod;
import it.unibo.cmdb.monitoring.model.icinga.UserVar;
import it.unibo.cmdb.monitoring.model.icinga.Zone;
import it.unibo.cmdb.monitoring.model.icinga.ZoneElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Service</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getDependencies <em>Dependencies</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getNotifications <em>Notifications</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getScheduledDowntimes <em>Scheduled Downtimes</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getZone <em>Zone</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getDisplay_name <em>Display name</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getHost <em>Host</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getGroups <em>Groups</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getVars <em>Vars</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getCheck_command <em>Check command</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getMax_check_attempts <em>Max check attempts</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getCheck_period <em>Check period</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getCheck_interval <em>Check interval</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getRetry_interval <em>Retry interval</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#isEnable_notifications <em>Enable notifications</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#isEnable_active_checks <em>Enable active checks</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#isEnable_passive_checks <em>Enable passive checks</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#isEnable_event_handler <em>Enable event handler</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#isEnable_flapping <em>Enable flapping</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#isEnable_perfdata <em>Enable perfdata</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getEvent_command <em>Event command</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getFlapping_threshold <em>Flapping threshold</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#isVolatile <em>Volatile</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getCommand_endpoint <em>Command endpoint</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getNotes <em>Notes</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getNotes_url <em>Notes url</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getAction_url <em>Action url</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getIcon_image <em>Icon image</em>}</li>
 *   <li>{@link it.unibo.cmdb.monitoring.model.icinga.impl.ServiceImpl#getIcon_image_alt <em>Icon image alt</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ServiceImpl extends ConfigurationObjectImpl implements Service {
	/**
	 * The cached value of the '{@link #getDependencies() <em>Dependencies</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDependencies()
	 * @generated
	 * @ordered
	 */
	protected EList<Dependency> dependencies;

	/**
	 * The cached value of the '{@link #getNotifications() <em>Notifications</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNotifications()
	 * @generated
	 * @ordered
	 */
	protected EList<Notification> notifications;

	/**
	 * The cached value of the '{@link #getScheduledDowntimes() <em>Scheduled Downtimes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScheduledDowntimes()
	 * @generated
	 * @ordered
	 */
	protected EList<ScheduledDowntime> scheduledDowntimes;

	/**
	 * The cached value of the '{@link #getZone() <em>Zone</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZone()
	 * @generated
	 * @ordered
	 */
	protected Zone zone;

	/**
	 * The default value of the '{@link #getDisplay_name() <em>Display name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDisplay_name()
	 * @generated
	 * @ordered
	 */
	protected static final String DISPLAY_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDisplay_name() <em>Display name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDisplay_name()
	 * @generated
	 * @ordered
	 */
	protected String display_name = DISPLAY_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getGroups() <em>Groups</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGroups()
	 * @generated
	 * @ordered
	 */
	protected EList<ServiceGroup> groups;

	/**
	 * The cached value of the '{@link #getVars() <em>Vars</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVars()
	 * @generated
	 * @ordered
	 */
	protected EList<UserVar> vars;

	/**
	 * The cached value of the '{@link #getCheck_command() <em>Check command</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheck_command()
	 * @generated
	 * @ordered
	 */
	protected CheckCommand check_command;

	/**
	 * The default value of the '{@link #getMax_check_attempts() <em>Max check attempts</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMax_check_attempts()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_CHECK_ATTEMPTS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMax_check_attempts() <em>Max check attempts</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMax_check_attempts()
	 * @generated
	 * @ordered
	 */
	protected int max_check_attempts = MAX_CHECK_ATTEMPTS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCheck_period() <em>Check period</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheck_period()
	 * @generated
	 * @ordered
	 */
	protected TimePeriod check_period;

	/**
	 * The default value of the '{@link #getCheck_interval() <em>Check interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheck_interval()
	 * @generated
	 * @ordered
	 */
	protected static final int CHECK_INTERVAL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCheck_interval() <em>Check interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheck_interval()
	 * @generated
	 * @ordered
	 */
	protected int check_interval = CHECK_INTERVAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getRetry_interval() <em>Retry interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRetry_interval()
	 * @generated
	 * @ordered
	 */
	protected static final int RETRY_INTERVAL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRetry_interval() <em>Retry interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRetry_interval()
	 * @generated
	 * @ordered
	 */
	protected int retry_interval = RETRY_INTERVAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isEnable_notifications() <em>Enable notifications</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_notifications()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLE_NOTIFICATIONS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEnable_notifications() <em>Enable notifications</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_notifications()
	 * @generated
	 * @ordered
	 */
	protected boolean enable_notifications = ENABLE_NOTIFICATIONS_EDEFAULT;

	/**
	 * The default value of the '{@link #isEnable_active_checks() <em>Enable active checks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_active_checks()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLE_ACTIVE_CHECKS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEnable_active_checks() <em>Enable active checks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_active_checks()
	 * @generated
	 * @ordered
	 */
	protected boolean enable_active_checks = ENABLE_ACTIVE_CHECKS_EDEFAULT;

	/**
	 * The default value of the '{@link #isEnable_passive_checks() <em>Enable passive checks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_passive_checks()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLE_PASSIVE_CHECKS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEnable_passive_checks() <em>Enable passive checks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_passive_checks()
	 * @generated
	 * @ordered
	 */
	protected boolean enable_passive_checks = ENABLE_PASSIVE_CHECKS_EDEFAULT;

	/**
	 * The default value of the '{@link #isEnable_event_handler() <em>Enable event handler</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_event_handler()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLE_EVENT_HANDLER_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEnable_event_handler() <em>Enable event handler</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_event_handler()
	 * @generated
	 * @ordered
	 */
	protected boolean enable_event_handler = ENABLE_EVENT_HANDLER_EDEFAULT;

	/**
	 * The default value of the '{@link #isEnable_flapping() <em>Enable flapping</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_flapping()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLE_FLAPPING_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEnable_flapping() <em>Enable flapping</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_flapping()
	 * @generated
	 * @ordered
	 */
	protected boolean enable_flapping = ENABLE_FLAPPING_EDEFAULT;

	/**
	 * The default value of the '{@link #isEnable_perfdata() <em>Enable perfdata</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_perfdata()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLE_PERFDATA_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEnable_perfdata() <em>Enable perfdata</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnable_perfdata()
	 * @generated
	 * @ordered
	 */
	protected boolean enable_perfdata = ENABLE_PERFDATA_EDEFAULT;

	/**
	 * The cached value of the '{@link #getEvent_command() <em>Event command</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEvent_command()
	 * @generated
	 * @ordered
	 */
	protected EventCommand event_command;

	/**
	 * The default value of the '{@link #getFlapping_threshold() <em>Flapping threshold</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFlapping_threshold()
	 * @generated
	 * @ordered
	 */
	protected static final double FLAPPING_THRESHOLD_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getFlapping_threshold() <em>Flapping threshold</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFlapping_threshold()
	 * @generated
	 * @ordered
	 */
	protected double flapping_threshold = FLAPPING_THRESHOLD_EDEFAULT;

	/**
	 * The default value of the '{@link #isVolatile() <em>Volatile</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVolatile()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VOLATILE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isVolatile() <em>Volatile</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVolatile()
	 * @generated
	 * @ordered
	 */
	protected boolean volatile_ = VOLATILE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCommand_endpoint() <em>Command endpoint</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommand_endpoint()
	 * @generated
	 * @ordered
	 */
	protected Endpoint command_endpoint;

	/**
	 * The default value of the '{@link #getNotes() <em>Notes</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNotes()
	 * @generated
	 * @ordered
	 */
	protected static final String NOTES_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getNotes() <em>Notes</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNotes()
	 * @generated
	 * @ordered
	 */
	protected String notes = NOTES_EDEFAULT;

	/**
	 * The default value of the '{@link #getNotes_url() <em>Notes url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNotes_url()
	 * @generated
	 * @ordered
	 */
	protected static final String NOTES_URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getNotes_url() <em>Notes url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNotes_url()
	 * @generated
	 * @ordered
	 */
	protected String notes_url = NOTES_URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getAction_url() <em>Action url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAction_url()
	 * @generated
	 * @ordered
	 */
	protected static final String ACTION_URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAction_url() <em>Action url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAction_url()
	 * @generated
	 * @ordered
	 */
	protected String action_url = ACTION_URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getIcon_image() <em>Icon image</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon_image()
	 * @generated
	 * @ordered
	 */
	protected static final String ICON_IMAGE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIcon_image() <em>Icon image</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon_image()
	 * @generated
	 * @ordered
	 */
	protected String icon_image = ICON_IMAGE_EDEFAULT;

	/**
	 * The default value of the '{@link #getIcon_image_alt() <em>Icon image alt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon_image_alt()
	 * @generated
	 * @ordered
	 */
	protected static final String ICON_IMAGE_ALT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIcon_image_alt() <em>Icon image alt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon_image_alt()
	 * @generated
	 * @ordered
	 */
	protected String icon_image_alt = ICON_IMAGE_ALT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IcingaPackage.Literals.SERVICE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Dependency> getDependencies() {
		if (dependencies == null) {
			dependencies = new EObjectContainmentWithInverseEList<Dependency>(Dependency.class, this, IcingaPackage.SERVICE__DEPENDENCIES, IcingaPackage.DEPENDENCY__PARENT);
		}
		return dependencies;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Notification> getNotifications() {
		if (notifications == null) {
			notifications = new EObjectContainmentWithInverseEList<Notification>(Notification.class, this, IcingaPackage.SERVICE__NOTIFICATIONS, IcingaPackage.NOTIFICATION__CHECKABLE);
		}
		return notifications;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ScheduledDowntime> getScheduledDowntimes() {
		if (scheduledDowntimes == null) {
			scheduledDowntimes = new EObjectWithInverseResolvingEList<ScheduledDowntime>(ScheduledDowntime.class, this, IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES, IcingaPackage.SCHEDULED_DOWNTIME__CHECKABLE);
		}
		return scheduledDowntimes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone getZone() {
		if (zone != null && zone.eIsProxy()) {
			InternalEObject oldZone = (InternalEObject)zone;
			zone = (Zone)eResolveProxy(oldZone);
			if (zone != oldZone) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.RESOLVE, IcingaPackage.SERVICE__ZONE, oldZone, zone));
			}
		}
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Zone basicGetZone() {
		return zone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetZone(Zone newZone, NotificationChain msgs) {
		Zone oldZone = zone;
		zone = newZone;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ZONE, oldZone, newZone);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setZone(Zone newZone) {
		if (newZone != zone) {
			NotificationChain msgs = null;
			if (zone != null)
				msgs = ((InternalEObject)zone).eInverseRemove(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
			if (newZone != null)
				msgs = ((InternalEObject)newZone).eInverseAdd(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
			msgs = basicSetZone(newZone, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ZONE, newZone, newZone));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDisplay_name() {
		return display_name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDisplay_name(String newDisplay_name) {
		String oldDisplay_name = display_name;
		display_name = newDisplay_name;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__DISPLAY_NAME, oldDisplay_name, display_name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Host getHost() {
		if (eContainerFeatureID() != IcingaPackage.SERVICE__HOST) return null;
		return (Host)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetHost(Host newHost, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newHost, IcingaPackage.SERVICE__HOST, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHost(Host newHost) {
		if (newHost != eInternalContainer() || (eContainerFeatureID() != IcingaPackage.SERVICE__HOST && newHost != null)) {
			if (EcoreUtil.isAncestor(this, newHost))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newHost != null)
				msgs = ((InternalEObject)newHost).eInverseAdd(this, IcingaPackage.HOST__SERVICES, Host.class, msgs);
			msgs = basicSetHost(newHost, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__HOST, newHost, newHost));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ServiceGroup> getGroups() {
		if (groups == null) {
			groups = new EObjectResolvingEList<ServiceGroup>(ServiceGroup.class, this, IcingaPackage.SERVICE__GROUPS);
		}
		return groups;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<UserVar> getVars() {
		if (vars == null) {
			vars = new EObjectContainmentEList<UserVar>(UserVar.class, this, IcingaPackage.SERVICE__VARS);
		}
		return vars;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CheckCommand getCheck_command() {
		if (check_command != null && check_command.eIsProxy()) {
			InternalEObject oldCheck_command = (InternalEObject)check_command;
			check_command = (CheckCommand)eResolveProxy(oldCheck_command);
			if (check_command != oldCheck_command) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.RESOLVE, IcingaPackage.SERVICE__CHECK_COMMAND, oldCheck_command, check_command));
			}
		}
		return check_command;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CheckCommand basicGetCheck_command() {
		return check_command;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCheck_command(CheckCommand newCheck_command) {
		CheckCommand oldCheck_command = check_command;
		check_command = newCheck_command;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__CHECK_COMMAND, oldCheck_command, check_command));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMax_check_attempts() {
		return max_check_attempts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMax_check_attempts(int newMax_check_attempts) {
		int oldMax_check_attempts = max_check_attempts;
		max_check_attempts = newMax_check_attempts;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__MAX_CHECK_ATTEMPTS, oldMax_check_attempts, max_check_attempts));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimePeriod getCheck_period() {
		if (check_period != null && check_period.eIsProxy()) {
			InternalEObject oldCheck_period = (InternalEObject)check_period;
			check_period = (TimePeriod)eResolveProxy(oldCheck_period);
			if (check_period != oldCheck_period) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.RESOLVE, IcingaPackage.SERVICE__CHECK_PERIOD, oldCheck_period, check_period));
			}
		}
		return check_period;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimePeriod basicGetCheck_period() {
		return check_period;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCheck_period(TimePeriod newCheck_period) {
		TimePeriod oldCheck_period = check_period;
		check_period = newCheck_period;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__CHECK_PERIOD, oldCheck_period, check_period));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCheck_interval() {
		return check_interval;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCheck_interval(int newCheck_interval) {
		int oldCheck_interval = check_interval;
		check_interval = newCheck_interval;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__CHECK_INTERVAL, oldCheck_interval, check_interval));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getRetry_interval() {
		return retry_interval;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRetry_interval(int newRetry_interval) {
		int oldRetry_interval = retry_interval;
		retry_interval = newRetry_interval;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__RETRY_INTERVAL, oldRetry_interval, retry_interval));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEnable_notifications() {
		return enable_notifications;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnable_notifications(boolean newEnable_notifications) {
		boolean oldEnable_notifications = enable_notifications;
		enable_notifications = newEnable_notifications;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ENABLE_NOTIFICATIONS, oldEnable_notifications, enable_notifications));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEnable_active_checks() {
		return enable_active_checks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnable_active_checks(boolean newEnable_active_checks) {
		boolean oldEnable_active_checks = enable_active_checks;
		enable_active_checks = newEnable_active_checks;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ENABLE_ACTIVE_CHECKS, oldEnable_active_checks, enable_active_checks));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEnable_passive_checks() {
		return enable_passive_checks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnable_passive_checks(boolean newEnable_passive_checks) {
		boolean oldEnable_passive_checks = enable_passive_checks;
		enable_passive_checks = newEnable_passive_checks;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ENABLE_PASSIVE_CHECKS, oldEnable_passive_checks, enable_passive_checks));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEnable_event_handler() {
		return enable_event_handler;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnable_event_handler(boolean newEnable_event_handler) {
		boolean oldEnable_event_handler = enable_event_handler;
		enable_event_handler = newEnable_event_handler;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ENABLE_EVENT_HANDLER, oldEnable_event_handler, enable_event_handler));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEnable_flapping() {
		return enable_flapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnable_flapping(boolean newEnable_flapping) {
		boolean oldEnable_flapping = enable_flapping;
		enable_flapping = newEnable_flapping;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ENABLE_FLAPPING, oldEnable_flapping, enable_flapping));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEnable_perfdata() {
		return enable_perfdata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnable_perfdata(boolean newEnable_perfdata) {
		boolean oldEnable_perfdata = enable_perfdata;
		enable_perfdata = newEnable_perfdata;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ENABLE_PERFDATA, oldEnable_perfdata, enable_perfdata));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EventCommand getEvent_command() {
		if (event_command != null && event_command.eIsProxy()) {
			InternalEObject oldEvent_command = (InternalEObject)event_command;
			event_command = (EventCommand)eResolveProxy(oldEvent_command);
			if (event_command != oldEvent_command) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.RESOLVE, IcingaPackage.SERVICE__EVENT_COMMAND, oldEvent_command, event_command));
			}
		}
		return event_command;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EventCommand basicGetEvent_command() {
		return event_command;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEvent_command(EventCommand newEvent_command) {
		EventCommand oldEvent_command = event_command;
		event_command = newEvent_command;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__EVENT_COMMAND, oldEvent_command, event_command));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getFlapping_threshold() {
		return flapping_threshold;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFlapping_threshold(double newFlapping_threshold) {
		double oldFlapping_threshold = flapping_threshold;
		flapping_threshold = newFlapping_threshold;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__FLAPPING_THRESHOLD, oldFlapping_threshold, flapping_threshold));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isVolatile() {
		return volatile_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVolatile(boolean newVolatile) {
		boolean oldVolatile = volatile_;
		volatile_ = newVolatile;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__VOLATILE, oldVolatile, volatile_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Endpoint getCommand_endpoint() {
		if (command_endpoint != null && command_endpoint.eIsProxy()) {
			InternalEObject oldCommand_endpoint = (InternalEObject)command_endpoint;
			command_endpoint = (Endpoint)eResolveProxy(oldCommand_endpoint);
			if (command_endpoint != oldCommand_endpoint) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.RESOLVE, IcingaPackage.SERVICE__COMMAND_ENDPOINT, oldCommand_endpoint, command_endpoint));
			}
		}
		return command_endpoint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Endpoint basicGetCommand_endpoint() {
		return command_endpoint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCommand_endpoint(Endpoint newCommand_endpoint) {
		Endpoint oldCommand_endpoint = command_endpoint;
		command_endpoint = newCommand_endpoint;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__COMMAND_ENDPOINT, oldCommand_endpoint, command_endpoint));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getNotes() {
		return notes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNotes(String newNotes) {
		String oldNotes = notes;
		notes = newNotes;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__NOTES, oldNotes, notes));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getNotes_url() {
		return notes_url;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNotes_url(String newNotes_url) {
		String oldNotes_url = notes_url;
		notes_url = newNotes_url;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__NOTES_URL, oldNotes_url, notes_url));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAction_url() {
		return action_url;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAction_url(String newAction_url) {
		String oldAction_url = action_url;
		action_url = newAction_url;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ACTION_URL, oldAction_url, action_url));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIcon_image() {
		return icon_image;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIcon_image(String newIcon_image) {
		String oldIcon_image = icon_image;
		icon_image = newIcon_image;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ICON_IMAGE, oldIcon_image, icon_image));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIcon_image_alt() {
		return icon_image_alt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIcon_image_alt(String newIcon_image_alt) {
		String oldIcon_image_alt = icon_image_alt;
		icon_image_alt = newIcon_image_alt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, org.eclipse.emf.common.notify.Notification.SET, IcingaPackage.SERVICE__ICON_IMAGE_ALT, oldIcon_image_alt, icon_image_alt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.SERVICE__DEPENDENCIES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDependencies()).basicAdd(otherEnd, msgs);
			case IcingaPackage.SERVICE__NOTIFICATIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getNotifications()).basicAdd(otherEnd, msgs);
			case IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getScheduledDowntimes()).basicAdd(otherEnd, msgs);
			case IcingaPackage.SERVICE__ZONE:
				if (zone != null)
					msgs = ((InternalEObject)zone).eInverseRemove(this, IcingaPackage.ZONE__ELEMENTS, Zone.class, msgs);
				return basicSetZone((Zone)otherEnd, msgs);
			case IcingaPackage.SERVICE__HOST:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetHost((Host)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IcingaPackage.SERVICE__DEPENDENCIES:
				return ((InternalEList<?>)getDependencies()).basicRemove(otherEnd, msgs);
			case IcingaPackage.SERVICE__NOTIFICATIONS:
				return ((InternalEList<?>)getNotifications()).basicRemove(otherEnd, msgs);
			case IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES:
				return ((InternalEList<?>)getScheduledDowntimes()).basicRemove(otherEnd, msgs);
			case IcingaPackage.SERVICE__ZONE:
				return basicSetZone(null, msgs);
			case IcingaPackage.SERVICE__HOST:
				return basicSetHost(null, msgs);
			case IcingaPackage.SERVICE__VARS:
				return ((InternalEList<?>)getVars()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case IcingaPackage.SERVICE__HOST:
				return eInternalContainer().eInverseRemove(this, IcingaPackage.HOST__SERVICES, Host.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IcingaPackage.SERVICE__DEPENDENCIES:
				return getDependencies();
			case IcingaPackage.SERVICE__NOTIFICATIONS:
				return getNotifications();
			case IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES:
				return getScheduledDowntimes();
			case IcingaPackage.SERVICE__ZONE:
				if (resolve) return getZone();
				return basicGetZone();
			case IcingaPackage.SERVICE__DISPLAY_NAME:
				return getDisplay_name();
			case IcingaPackage.SERVICE__HOST:
				return getHost();
			case IcingaPackage.SERVICE__GROUPS:
				return getGroups();
			case IcingaPackage.SERVICE__VARS:
				return getVars();
			case IcingaPackage.SERVICE__CHECK_COMMAND:
				if (resolve) return getCheck_command();
				return basicGetCheck_command();
			case IcingaPackage.SERVICE__MAX_CHECK_ATTEMPTS:
				return getMax_check_attempts();
			case IcingaPackage.SERVICE__CHECK_PERIOD:
				if (resolve) return getCheck_period();
				return basicGetCheck_period();
			case IcingaPackage.SERVICE__CHECK_INTERVAL:
				return getCheck_interval();
			case IcingaPackage.SERVICE__RETRY_INTERVAL:
				return getRetry_interval();
			case IcingaPackage.SERVICE__ENABLE_NOTIFICATIONS:
				return isEnable_notifications();
			case IcingaPackage.SERVICE__ENABLE_ACTIVE_CHECKS:
				return isEnable_active_checks();
			case IcingaPackage.SERVICE__ENABLE_PASSIVE_CHECKS:
				return isEnable_passive_checks();
			case IcingaPackage.SERVICE__ENABLE_EVENT_HANDLER:
				return isEnable_event_handler();
			case IcingaPackage.SERVICE__ENABLE_FLAPPING:
				return isEnable_flapping();
			case IcingaPackage.SERVICE__ENABLE_PERFDATA:
				return isEnable_perfdata();
			case IcingaPackage.SERVICE__EVENT_COMMAND:
				if (resolve) return getEvent_command();
				return basicGetEvent_command();
			case IcingaPackage.SERVICE__FLAPPING_THRESHOLD:
				return getFlapping_threshold();
			case IcingaPackage.SERVICE__VOLATILE:
				return isVolatile();
			case IcingaPackage.SERVICE__COMMAND_ENDPOINT:
				if (resolve) return getCommand_endpoint();
				return basicGetCommand_endpoint();
			case IcingaPackage.SERVICE__NOTES:
				return getNotes();
			case IcingaPackage.SERVICE__NOTES_URL:
				return getNotes_url();
			case IcingaPackage.SERVICE__ACTION_URL:
				return getAction_url();
			case IcingaPackage.SERVICE__ICON_IMAGE:
				return getIcon_image();
			case IcingaPackage.SERVICE__ICON_IMAGE_ALT:
				return getIcon_image_alt();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IcingaPackage.SERVICE__DEPENDENCIES:
				getDependencies().clear();
				getDependencies().addAll((Collection<? extends Dependency>)newValue);
				return;
			case IcingaPackage.SERVICE__NOTIFICATIONS:
				getNotifications().clear();
				getNotifications().addAll((Collection<? extends Notification>)newValue);
				return;
			case IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES:
				getScheduledDowntimes().clear();
				getScheduledDowntimes().addAll((Collection<? extends ScheduledDowntime>)newValue);
				return;
			case IcingaPackage.SERVICE__ZONE:
				setZone((Zone)newValue);
				return;
			case IcingaPackage.SERVICE__DISPLAY_NAME:
				setDisplay_name((String)newValue);
				return;
			case IcingaPackage.SERVICE__HOST:
				setHost((Host)newValue);
				return;
			case IcingaPackage.SERVICE__GROUPS:
				getGroups().clear();
				getGroups().addAll((Collection<? extends ServiceGroup>)newValue);
				return;
			case IcingaPackage.SERVICE__VARS:
				getVars().clear();
				getVars().addAll((Collection<? extends UserVar>)newValue);
				return;
			case IcingaPackage.SERVICE__CHECK_COMMAND:
				setCheck_command((CheckCommand)newValue);
				return;
			case IcingaPackage.SERVICE__MAX_CHECK_ATTEMPTS:
				setMax_check_attempts((Integer)newValue);
				return;
			case IcingaPackage.SERVICE__CHECK_PERIOD:
				setCheck_period((TimePeriod)newValue);
				return;
			case IcingaPackage.SERVICE__CHECK_INTERVAL:
				setCheck_interval((Integer)newValue);
				return;
			case IcingaPackage.SERVICE__RETRY_INTERVAL:
				setRetry_interval((Integer)newValue);
				return;
			case IcingaPackage.SERVICE__ENABLE_NOTIFICATIONS:
				setEnable_notifications((Boolean)newValue);
				return;
			case IcingaPackage.SERVICE__ENABLE_ACTIVE_CHECKS:
				setEnable_active_checks((Boolean)newValue);
				return;
			case IcingaPackage.SERVICE__ENABLE_PASSIVE_CHECKS:
				setEnable_passive_checks((Boolean)newValue);
				return;
			case IcingaPackage.SERVICE__ENABLE_EVENT_HANDLER:
				setEnable_event_handler((Boolean)newValue);
				return;
			case IcingaPackage.SERVICE__ENABLE_FLAPPING:
				setEnable_flapping((Boolean)newValue);
				return;
			case IcingaPackage.SERVICE__ENABLE_PERFDATA:
				setEnable_perfdata((Boolean)newValue);
				return;
			case IcingaPackage.SERVICE__EVENT_COMMAND:
				setEvent_command((EventCommand)newValue);
				return;
			case IcingaPackage.SERVICE__FLAPPING_THRESHOLD:
				setFlapping_threshold((Double)newValue);
				return;
			case IcingaPackage.SERVICE__VOLATILE:
				setVolatile((Boolean)newValue);
				return;
			case IcingaPackage.SERVICE__COMMAND_ENDPOINT:
				setCommand_endpoint((Endpoint)newValue);
				return;
			case IcingaPackage.SERVICE__NOTES:
				setNotes((String)newValue);
				return;
			case IcingaPackage.SERVICE__NOTES_URL:
				setNotes_url((String)newValue);
				return;
			case IcingaPackage.SERVICE__ACTION_URL:
				setAction_url((String)newValue);
				return;
			case IcingaPackage.SERVICE__ICON_IMAGE:
				setIcon_image((String)newValue);
				return;
			case IcingaPackage.SERVICE__ICON_IMAGE_ALT:
				setIcon_image_alt((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IcingaPackage.SERVICE__DEPENDENCIES:
				getDependencies().clear();
				return;
			case IcingaPackage.SERVICE__NOTIFICATIONS:
				getNotifications().clear();
				return;
			case IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES:
				getScheduledDowntimes().clear();
				return;
			case IcingaPackage.SERVICE__ZONE:
				setZone((Zone)null);
				return;
			case IcingaPackage.SERVICE__DISPLAY_NAME:
				setDisplay_name(DISPLAY_NAME_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__HOST:
				setHost((Host)null);
				return;
			case IcingaPackage.SERVICE__GROUPS:
				getGroups().clear();
				return;
			case IcingaPackage.SERVICE__VARS:
				getVars().clear();
				return;
			case IcingaPackage.SERVICE__CHECK_COMMAND:
				setCheck_command((CheckCommand)null);
				return;
			case IcingaPackage.SERVICE__MAX_CHECK_ATTEMPTS:
				setMax_check_attempts(MAX_CHECK_ATTEMPTS_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__CHECK_PERIOD:
				setCheck_period((TimePeriod)null);
				return;
			case IcingaPackage.SERVICE__CHECK_INTERVAL:
				setCheck_interval(CHECK_INTERVAL_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__RETRY_INTERVAL:
				setRetry_interval(RETRY_INTERVAL_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ENABLE_NOTIFICATIONS:
				setEnable_notifications(ENABLE_NOTIFICATIONS_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ENABLE_ACTIVE_CHECKS:
				setEnable_active_checks(ENABLE_ACTIVE_CHECKS_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ENABLE_PASSIVE_CHECKS:
				setEnable_passive_checks(ENABLE_PASSIVE_CHECKS_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ENABLE_EVENT_HANDLER:
				setEnable_event_handler(ENABLE_EVENT_HANDLER_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ENABLE_FLAPPING:
				setEnable_flapping(ENABLE_FLAPPING_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ENABLE_PERFDATA:
				setEnable_perfdata(ENABLE_PERFDATA_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__EVENT_COMMAND:
				setEvent_command((EventCommand)null);
				return;
			case IcingaPackage.SERVICE__FLAPPING_THRESHOLD:
				setFlapping_threshold(FLAPPING_THRESHOLD_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__VOLATILE:
				setVolatile(VOLATILE_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__COMMAND_ENDPOINT:
				setCommand_endpoint((Endpoint)null);
				return;
			case IcingaPackage.SERVICE__NOTES:
				setNotes(NOTES_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__NOTES_URL:
				setNotes_url(NOTES_URL_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ACTION_URL:
				setAction_url(ACTION_URL_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ICON_IMAGE:
				setIcon_image(ICON_IMAGE_EDEFAULT);
				return;
			case IcingaPackage.SERVICE__ICON_IMAGE_ALT:
				setIcon_image_alt(ICON_IMAGE_ALT_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IcingaPackage.SERVICE__DEPENDENCIES:
				return dependencies != null && !dependencies.isEmpty();
			case IcingaPackage.SERVICE__NOTIFICATIONS:
				return notifications != null && !notifications.isEmpty();
			case IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES:
				return scheduledDowntimes != null && !scheduledDowntimes.isEmpty();
			case IcingaPackage.SERVICE__ZONE:
				return zone != null;
			case IcingaPackage.SERVICE__DISPLAY_NAME:
				return DISPLAY_NAME_EDEFAULT == null ? display_name != null : !DISPLAY_NAME_EDEFAULT.equals(display_name);
			case IcingaPackage.SERVICE__HOST:
				return getHost() != null;
			case IcingaPackage.SERVICE__GROUPS:
				return groups != null && !groups.isEmpty();
			case IcingaPackage.SERVICE__VARS:
				return vars != null && !vars.isEmpty();
			case IcingaPackage.SERVICE__CHECK_COMMAND:
				return check_command != null;
			case IcingaPackage.SERVICE__MAX_CHECK_ATTEMPTS:
				return max_check_attempts != MAX_CHECK_ATTEMPTS_EDEFAULT;
			case IcingaPackage.SERVICE__CHECK_PERIOD:
				return check_period != null;
			case IcingaPackage.SERVICE__CHECK_INTERVAL:
				return check_interval != CHECK_INTERVAL_EDEFAULT;
			case IcingaPackage.SERVICE__RETRY_INTERVAL:
				return retry_interval != RETRY_INTERVAL_EDEFAULT;
			case IcingaPackage.SERVICE__ENABLE_NOTIFICATIONS:
				return enable_notifications != ENABLE_NOTIFICATIONS_EDEFAULT;
			case IcingaPackage.SERVICE__ENABLE_ACTIVE_CHECKS:
				return enable_active_checks != ENABLE_ACTIVE_CHECKS_EDEFAULT;
			case IcingaPackage.SERVICE__ENABLE_PASSIVE_CHECKS:
				return enable_passive_checks != ENABLE_PASSIVE_CHECKS_EDEFAULT;
			case IcingaPackage.SERVICE__ENABLE_EVENT_HANDLER:
				return enable_event_handler != ENABLE_EVENT_HANDLER_EDEFAULT;
			case IcingaPackage.SERVICE__ENABLE_FLAPPING:
				return enable_flapping != ENABLE_FLAPPING_EDEFAULT;
			case IcingaPackage.SERVICE__ENABLE_PERFDATA:
				return enable_perfdata != ENABLE_PERFDATA_EDEFAULT;
			case IcingaPackage.SERVICE__EVENT_COMMAND:
				return event_command != null;
			case IcingaPackage.SERVICE__FLAPPING_THRESHOLD:
				return flapping_threshold != FLAPPING_THRESHOLD_EDEFAULT;
			case IcingaPackage.SERVICE__VOLATILE:
				return volatile_ != VOLATILE_EDEFAULT;
			case IcingaPackage.SERVICE__COMMAND_ENDPOINT:
				return command_endpoint != null;
			case IcingaPackage.SERVICE__NOTES:
				return NOTES_EDEFAULT == null ? notes != null : !NOTES_EDEFAULT.equals(notes);
			case IcingaPackage.SERVICE__NOTES_URL:
				return NOTES_URL_EDEFAULT == null ? notes_url != null : !NOTES_URL_EDEFAULT.equals(notes_url);
			case IcingaPackage.SERVICE__ACTION_URL:
				return ACTION_URL_EDEFAULT == null ? action_url != null : !ACTION_URL_EDEFAULT.equals(action_url);
			case IcingaPackage.SERVICE__ICON_IMAGE:
				return ICON_IMAGE_EDEFAULT == null ? icon_image != null : !ICON_IMAGE_EDEFAULT.equals(icon_image);
			case IcingaPackage.SERVICE__ICON_IMAGE_ALT:
				return ICON_IMAGE_ALT_EDEFAULT == null ? icon_image_alt != null : !ICON_IMAGE_ALT_EDEFAULT.equals(icon_image_alt);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Checkable.class) {
			switch (derivedFeatureID) {
				case IcingaPackage.SERVICE__DEPENDENCIES: return IcingaPackage.CHECKABLE__DEPENDENCIES;
				case IcingaPackage.SERVICE__NOTIFICATIONS: return IcingaPackage.CHECKABLE__NOTIFICATIONS;
				case IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES: return IcingaPackage.CHECKABLE__SCHEDULED_DOWNTIMES;
				default: return -1;
			}
		}
		if (baseClass == ZoneElement.class) {
			switch (derivedFeatureID) {
				case IcingaPackage.SERVICE__ZONE: return IcingaPackage.ZONE_ELEMENT__ZONE;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Checkable.class) {
			switch (baseFeatureID) {
				case IcingaPackage.CHECKABLE__DEPENDENCIES: return IcingaPackage.SERVICE__DEPENDENCIES;
				case IcingaPackage.CHECKABLE__NOTIFICATIONS: return IcingaPackage.SERVICE__NOTIFICATIONS;
				case IcingaPackage.CHECKABLE__SCHEDULED_DOWNTIMES: return IcingaPackage.SERVICE__SCHEDULED_DOWNTIMES;
				default: return -1;
			}
		}
		if (baseClass == ZoneElement.class) {
			switch (baseFeatureID) {
				case IcingaPackage.ZONE_ELEMENT__ZONE: return IcingaPackage.SERVICE__ZONE;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (display_name: ");
		result.append(display_name);
		result.append(", max_check_attempts: ");
		result.append(max_check_attempts);
		result.append(", check_interval: ");
		result.append(check_interval);
		result.append(", retry_interval: ");
		result.append(retry_interval);
		result.append(", enable_notifications: ");
		result.append(enable_notifications);
		result.append(", enable_active_checks: ");
		result.append(enable_active_checks);
		result.append(", enable_passive_checks: ");
		result.append(enable_passive_checks);
		result.append(", enable_event_handler: ");
		result.append(enable_event_handler);
		result.append(", enable_flapping: ");
		result.append(enable_flapping);
		result.append(", enable_perfdata: ");
		result.append(enable_perfdata);
		result.append(", flapping_threshold: ");
		result.append(flapping_threshold);
		result.append(", volatile: ");
		result.append(volatile_);
		result.append(", notes: ");
		result.append(notes);
		result.append(", notes_url: ");
		result.append(notes_url);
		result.append(", action_url: ");
		result.append(action_url);
		result.append(", icon_image: ");
		result.append(icon_image);
		result.append(", icon_image_alt: ");
		result.append(icon_image_alt);
		result.append(')');
		return result.toString();
	}

} //ServiceImpl
