package tests.configuration;

import static org.junit.Assert.*;

import java.io.IOException;
import java.util.Map;

import org.cmdbuild.config.DmsProperties;
import org.junit.BeforeClass;
import tests.TestJFC;

public class TestJFCWithConf extends TestJFC {
	static DmsProperties innerProperties  = new DmsProperties();
	static ForwardingDMSProperties dmsProperties = new ForwardingDMSProperties(innerProperties);
	
	@BeforeClass
	public static void readFile() throws IOException{
		innerProperties.load("src/test/resources/confs/dms-test-jfc.conf");
		 
	    assertNotEquals("Administrator",dmsProperties.getAlfrescoPassword());
		assertEquals("local",dmsProperties.getCmisBindingType());
		assertEquals("org.cmdbuild.dms.cmis.forwarder.NuxeoServiceFactory",
				dmsProperties.getLocalServiceFactory());
		assertTrue(dmsProperties.getSessionParameters().containsKey("nuxeo.automation.url"));
		assertTrue(dmsProperties.getSessionParameters().containsKey("nuxeo.automation.user"));
		assertTrue(dmsProperties.getSessionParameters().containsKey("nuxeo.automation.password"));
	}
	@Override
	public String getCmisUser() {
		return dmsProperties.getAlfrescoUser();
	}
	@Override
	public String getCmisPassword() {
		return dmsProperties.getAlfrescoPassword();
	}
	
	@Override
	public String getCmisBindingType() {
		return dmsProperties.getCmisBindingType();
	}
	
	@Override
	public String getLocalServiceFactory() {
		return dmsProperties.getLocalServiceFactory();
	}

	@Override
	public Map<String, String> getSessionParameters() {
		return dmsProperties.getSessionParameters();
	}
}
