package org.cmdbuild.dms.cmis.alfresco;

import java.util.Arrays;
import java.util.List;

import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Item;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.cmdbuild.dms.MetadataType;
import org.cmdbuild.dms.cmis.Converter;

public class CategoriesConverter implements Converter {
	private Context context;
	
	@Override
	public void setContext(Context context) {
		this.context = context;
		
	}
	
	@Override	
	public boolean isAsymmetric() {
		return true;
	}
	
	@Override
	public MetadataType getType(PropertyDefinition<?> propertyDefinition) {
		return MetadataType.TEXT;
	}

	@Override
	public Object convertToCmisValue(Session cmisSession, PropertyDefinition<?> propertyDefinition, String value) {
		Item category = null;
		if(value != null) {
			for(QueryResult result : cmisSession.query("SELECT * FROM cm:category WHERE CONTAINS ('PATH:\"/cm:generalclassifiable/cm:" + context.getConfiguration().getCmdbuildCategory() + "/cm:" + value + "\"')", false)){
				String objectId = result.getPropertyValueByQueryName("cmis:objectId");
				CmisObject cmisObject = cmisSession.getObject(objectId);
				if(cmisObject instanceof Item) {
					category = (Item)cmisObject;
				}
			}
		}
		return category != null ? Arrays.asList((String)category.getPropertyValue("alfcmis:nodeRef")) : null;
	}

	@Override	
	public String convertFromCmisValue(Session cmisSession, PropertyDefinition<?> propertyDefinition, Object cmisValue) {
		String category = null;
		if(cmisValue != null && cmisValue instanceof List<?>) {
			for(Object value : (List<?>)cmisValue) {
				if(category == null) {
					CmisObject categoryObject = cmisSession.getObject((String)value);
					if(categoryObject != null)
						category = categoryObject.getName();
				}
			}
		}
		return category;
	}
}
