package org.cmdbuild.dms.cmis.nuxeo;

import java.util.Collections;
import java.util.List;

import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.commons.lang3.StringUtils;
import org.cmdbuild.dms.DmsService.LoggingSupport;
import org.cmdbuild.dms.MetadataType;
import org.cmdbuild.dms.cmis.Converter;

public class CategoriesConverter implements Converter, LoggingSupport{
	
	@SuppressWarnings("unused")
	private Context context;
	
	@Override
	public void setContext(Context context) {
		this.context = context;
		
	}
	
	@Override	
	public boolean isAsymmetric() {
		return true;
	}
	
	@Override
	public MetadataType getType(PropertyDefinition<?> propertyDefinition) {
		return MetadataType.TEXT;
	}

	@Override
	public Object convertToCmisValue(Session cmisSession, PropertyDefinition<?> propertyDefinition, String value) {
		
		logger.debug("(convertToCmisValue)Convert property " + value  + " to cmis value");
		return Collections.singletonList(value);
	}

	@Override	
	public String convertFromCmisValue(Session cmisSession, PropertyDefinition<?> propertyDefinition, Object cmisValue) {
		String category = null;
		if(cmisValue != null && cmisValue instanceof List<?>) {
			 List<?> valueAsList = (List<?>) cmisValue;
			 if (valueAsList.size()> 0) {
				 category = (String) valueAsList.get(0);
			 } else {
				 category = StringUtils.EMPTY;
			 }
		}
		logger.debug("convert from cmis value " + cmisValue  + " to category definition :" + category);
		return category;
	}
}
