package org.cmdbuild.dms.cmis.nuxeo;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.chemistry.opencmis.bridge.CachedBindingCmisService;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.PropertyIds;
import org.apache.chemistry.opencmis.commons.SessionParameter;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.cmdbuild.dms.DmsService.LoggingSupport;
import org.nuxeo.ecm.automation.client.Constants;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.model.Document;

public class NuxeoForwardingService extends CachedBindingCmisService implements LoggingSupport{
	private static final long serialVersionUID = -7665488481989639216L;
		
	public static final String NUXEO_AUTOMATION_URL = "nuxeo.automation.url";
	public static final String NUXEO_AUTOMATION_USER = "nuxeo.automation.user";
	public static final String NUXEO_AUTOMATION_PASSWORD = "nuxeo.automation.password";		
	private static final String DUMMY_TYPE_NAMESPACE = "http://docs.oasis-open.org/ns/cmis/messaging/200908/";
	private static final String DUMMY_PROPERTY_NAMESPACE = "http://nuxeo.hasNoNamespace4Properties";
	private static final String CMDBUILD_NAMESPACE = "org.cmdbuild.dms.alfresco";

	private CmisBinding _cmisBinding = null;
	private org.apache.chemistry.opencmis.client.api.Session _session = null;
	private Map<String, String> _rsParameters;
	private String _nuxeoAutomationUrl 	= null;
	private String _nuxeoAutomationUser = null;
	private String _nuxeoAutomationPwd 	= null;
	
	public NuxeoForwardingService() {
		super();
	}
	
	@Override
    public void init(Map<String, String> parameters) {
		super.init(parameters);
		_nuxeoAutomationUrl 	= (String) parameters.get(NUXEO_AUTOMATION_URL);
		_nuxeoAutomationUser 	= (String) parameters.get(NUXEO_AUTOMATION_USER);
		_nuxeoAutomationPwd 	= (String) parameters.get(NUXEO_AUTOMATION_PASSWORD);
		logger.info("in init" + _nuxeoAutomationUrl);
                
        _rsParameters = new HashMap<String, String>(parameters);
        _rsParameters.remove(SessionParameter.BINDING_TYPE);
        _rsParameters.put(SessionParameter.BINDING_TYPE, BindingType.BROWSER.value());
		_rsParameters.put(SessionParameter.BROWSER_URL, parameters.get(SessionParameter.BROWSER_URL));
    }
		
	public CmisBinding createCmisBinding() {
		final SessionFactory sessionFactory = SessionFactoryImpl.newInstance();
		final List<Repository> repositories = sessionFactory.getRepositories(_rsParameters);       
        final Repository repository = repositories.get(0);
		_session = repository.createSession();
		return _session.getBinding();
	}
	
	protected boolean getCacheEnabled() {
		return false;
	}
	
	@Override
	public CmisBinding getCmisBindingFromCache() {
		return _cmisBinding;
	}
	
	@Override
	public CmisBinding putCmisBindingIntoCache(CmisBinding binding) {
		return _cmisBinding = binding;
	}
	
	@Override
	public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension){
		PropertyData<?> secondaryTypes = properties.getProperties().get(PropertyIds.SECONDARY_OBJECT_TYPE_IDS);
		logger.debug("CheckIn document, got secondary types "+ secondaryTypes);
		if (secondaryTypes != null){
			updateSercondaryTypes(repositoryId,objectId.getValue(),secondaryTypes);
		}
		Properties newProperties = correctCmisReadOnlyProperty(properties);
		super.checkIn(repositoryId, objectId, major, newProperties, contentStream, checkinComment, policies, addAces, removeAces, extension); 
	}
	
	@Override
	public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension){
		for (String p: properties.getProperties().keySet()) {
			logger.debug("createDocument, prop to set  "+ p);
		}
		PropertyData<?> secondaryTypes = 
				properties.getProperties().get(PropertyIds.SECONDARY_OBJECT_TYPE_IDS);

		List<String> toDelay = new LinkedList<String>();
		if (secondaryTypes != null){
			logger.debug("createDocument, got secondary types "+ secondaryTypes);
			for (Object secondaryType : secondaryTypes.getValues()){
				TypeDefinition typeDef = getTypeDefinition(repositoryId, (String) secondaryType, null);
				Map<String, PropertyDefinition<?>> propDefs = typeDef.getPropertyDefinitions();
				for (Entry<String, PropertyDefinition<?>> propDef   : propDefs.entrySet()){
					toDelay.add(propDef.getKey());
				}
			}
		}
		Properties newProperties = correctCmisReadOnlyProperty(properties, toDelay);
		String result = 
				super.createDocument(repositoryId, newProperties, folderId, 
						contentStream, versioningState, policies, 
						addAces, removeAces, extension) ;
		
		if (secondaryTypes != null){
			updateSercondaryTypes(repositoryId,result,secondaryTypes);
		
			PropertiesImpl delayedProperties = new PropertiesImpl();
			for (String secondaryProperty : toDelay){
				final PropertyData<?> value = properties.getProperties().get(secondaryProperty);
				if (value != null){
					logger.debug("createDocument, will set delayed property" + secondaryProperty + "with value " +value);
					delayedProperties.addProperty( value);
				} else {
					logger.debug("createDocument, not setting property ad selayed (null value) " +  secondaryProperty );
				}
			}
			if ((toDelay.size() >0) && (delayedProperties.getPropertyList().size()>0)){
				logger.debug("createDocument, update delayed Properties");
				super.updateProperties(repositoryId, new Holder<String>(result), null, delayedProperties, extension);
			}
		}
		return result;
	}
		
	@Override
	public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension){
		TypeDefinition result = null;
		result = super.getTypeDefinition(repositoryId, typeId, extension);
		logger.debug("getTypeDefinition; namespace for typeId: " +typeId + " is: " + result.getLocalNamespace());
		logger.debug("getTypeDefinition; will rewrite: " + result.getId().startsWith("facet:cmdbuild:"));	
		if (result.getLocalNamespace() == null){
			logger.debug("getTypeDefinition; namespace was null");
			(( MutableTypeDefinition ) result).setLocalNamespace(DUMMY_TYPE_NAMESPACE);
		} else if (result.getId().startsWith("facet:cmdbuild:")){
			((MutableTypeDefinition) result).setLocalNamespace(CMDBUILD_NAMESPACE);
		}
		logger.debug("getTypeDefinition; namespace for typeId is now: " +typeId + " is: " + result.getLocalNamespace());

		for (PropertyDefinition<?> property: result.getPropertyDefinitions().values()){
			logger.debug("getTypeDefinition; processing Property " + property.getId());
			logger.debug("getTypeDefinition; namespace for propertydef: " +property.getId() + " is: " + property.getLocalNamespace()+"starts with cmdbuild_ "+ property.getId().startsWith("cmdbuild_"));
			logger.debug("getTypeDefinition; class is " + property.getClass());
			
			if (property.getLocalNamespace() == null){
				String newNamespace = property.getId().startsWith("cmdbuild_") ?
						CMDBUILD_NAMESPACE : DUMMY_PROPERTY_NAMESPACE;
				((AbstractPropertyDefinition<?>) property).setLocalNamespace(newNamespace);
			}
			
			if (PropertyIds.SECONDARY_OBJECT_TYPE_IDS.equals(property.getId())) {
				logger.debug("rgetTypeDefinition; rewriting secondary type Id updatability");
				((AbstractPropertyDefinition<?>) property).setUpdatability(Updatability.READWRITE);
			}
		}
		logger.debug("end  type def" + typeId);
		return result;
	}
	
	@Override
	public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension){
		
		PropertyData<?> secondaryTypes = 
				properties.getProperties().get(PropertyIds.SECONDARY_OBJECT_TYPE_IDS);
		logger.debug("updateProperties, got secondary types "+ secondaryTypes);
		
		if (secondaryTypes != null){
			updateSercondaryTypes(repositoryId,objectId.getValue(),secondaryTypes);
		}
		Properties newProperties = correctCmisReadOnlyProperty( properties);
		super.updateProperties(repositoryId, objectId, changeToken, newProperties, extension);
		
	}
		
	private Properties correctCmisReadOnlyProperty(Properties properties, List<String> toDelay) {
		Properties newProperties = properties;
		if ((properties != null) && (properties.getProperties() != null)) {
			Collection<PropertyData<?>> propertiesData = new LinkedList<PropertyData<?>>();
			for (PropertyData<?> p : properties.getPropertyList()){
				
				if (PropertyIds.DESCRIPTION.equals(p.getId())){
					//do nothing
					logger.debug("Do not process attribute " + p.getId());
				} else if (PropertyIds.SECONDARY_OBJECT_TYPE_IDS.equals(p.getId())) {
					//do nothing
					logger.debug("Do not process attribute " + p.getId());
				} else if (toDelay.contains(p.getId())) { 
					//do nothing
					logger.debug("Do not process delayed attribute from secondaryType " + p.getId());
				} else {
					propertiesData.add(p);
				}
			}
			
			newProperties = new PropertiesImpl(propertiesData);
		}
		return newProperties;
	}
	private Properties correctCmisReadOnlyProperty(Properties properties) {
		return correctCmisReadOnlyProperty(properties,Collections.<String> emptyList());
	}
	

	@SuppressWarnings("unchecked")
	private void updateSercondaryTypes(String repositoryId, String objectId, PropertyData<?> secondaryTypes) {
		Session clientSession =null;	
		Properties actualProps = super.getProperties(repositoryId, objectId, null, null);		
		PropertyData<?> actualSecondaryTypesData = actualProps.getProperties().get(PropertyIds.SECONDARY_OBJECT_TYPE_IDS);
		LinkedList<String> actualSecondaryTypes = new LinkedList<String>();
		
		if (actualSecondaryTypesData != null){		
			actualSecondaryTypes = new LinkedList<String>((Collection<String>)actualSecondaryTypesData.getValues());
		}
		List<String> newsecondaryTypes = (List<String>) secondaryTypes.getValues();
		LinkedList<String> toAdd = new  LinkedList<String>(newsecondaryTypes);
		toAdd.removeAll(actualSecondaryTypes);
		LinkedList<String> toRemove = new  LinkedList<String>(actualSecondaryTypes);
		toRemove.removeAll(newsecondaryTypes);
		
		for (String s: actualSecondaryTypes){
			logger.debug("updateSercondaryTypes, actual secondaryType: " +s );
		}
		for (String s: newsecondaryTypes){
			logger.debug("updateSercondaryTypes, new secondaryType: " +s );
		}
		for (String s: toAdd){
			logger.debug("updateSercondaryTypes, add secondaryType: " +s );
		}
		for (String s: toRemove){
			logger.debug("updateSercondaryTypes, delete secondaryType: " +s );
		}
				
		try {
			logger.debug("Secondary type correction");
			logger.debug("updateSercondaryTypes, automation URL: " + _nuxeoAutomationUrl);
			if (_nuxeoAutomationUrl == null) {
				logger.warn("_nuxeoAutomationUrl is null");
			}
			HttpAutomationClient _httpclient = new HttpAutomationClient(_nuxeoAutomationUrl);
			if (_nuxeoAutomationUser == null) {
				logger.warn("_nuxeoAutomationUser is null");
			}
			if (_nuxeoAutomationPwd == null) {
				logger.warn("_nuxeoAutomationPAssword is null");
			}
			logger.debug("updateSercondaryTypes, auth user: {} password: {}",_nuxeoAutomationUser , _nuxeoAutomationPwd == null ? null:"not null XXXXXXXXX");
			_httpclient.setBasicAuth(_nuxeoAutomationUser,_nuxeoAutomationPwd);
			clientSession = _httpclient.getSession();
			logger.debug("updateSercondaryTypes, got a session");
			org.nuxeo.ecm.automation.client.model.Document nxDoc = getNuxeoDocument(objectId, clientSession);
			logger.debug("updateSercondaryTypes, got an document: {}" , nxDoc);
			logger.warn("updateSercondaryTypes, got a nuxeo doc setting type of " + objectId +"tp: " + (String) secondaryTypes.getFirstValue());
			for (Object secondaryType : toRemove){
				deleteNuxeoFacet(clientSession, nxDoc, secondaryType);
			}
			for (Object secondaryType : toAdd){
				addNuxeoFacet(clientSession, nxDoc, secondaryType);
			}
						
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (clientSession != null)clientSession.close();
		}				
	}
	
	private static String FACET_PREFIX = "facet:";
	private static String VALUE_KEY = "value";
	private static String FACET_KEY = "facet";
	private static String DOCUMENT_ADD_FACET = "Document.AddFacet";
	private static String DOCUMENT_FETCH = "Document.Fetch";
	private static String DOCUMENT_REMOVE_FACET = "Document.RemoveFacet";
	private static String ALL_SCHEMAS = "*";
	
	private Document getNuxeoDocument(String objectId, Session clientSession) throws IOException {	
		return (org.nuxeo.ecm.automation.client.model.Document) clientSession
			.newRequest(DOCUMENT_FETCH).setHeader(Constants.HEADER_NX_SCHEMAS, ALL_SCHEMAS)
			.set(VALUE_KEY, objectId).execute();
	}
	
	private void deleteNuxeoFacet(Session clientSession, org.nuxeo.ecm.automation.client.model.Document nxDoc, Object secondaryType) throws IOException {			
		String value = ((String) secondaryType).substring(FACET_PREFIX.length());
		logger.debug("Removing nuxeo facet : " + value);
		clientSession.
				newRequest(DOCUMENT_REMOVE_FACET).
				setInput(nxDoc).set(FACET_KEY, value).
				execute();
	}
	
	private void addNuxeoFacet(Session clientSession, org.nuxeo.ecm.automation.client.model.Document nxDoc,
			Object secondaryType) throws IOException {
		String value = ((String) secondaryType).substring("facet:".length());
		logger.debug("Adding nuxeo facet : " + value);
		clientSession.
				newRequest(DOCUMENT_ADD_FACET).
				setInput(nxDoc).set(FACET_KEY, value).
				execute();
	}			
}
