package org.cmdbuild.dms.cmis.nuxeo;

import java.util.Map;

import org.apache.chemistry.opencmis.bridge.CachedBindingCmisService;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.cmdbuild.dms.DmsService.LoggingSupport;

public class NuxeoServiceFactory extends AbstractServiceFactory implements LoggingSupport {
	private CachedBindingCmisService _service;
	private Map<String, String> _parameters;
	
	@Override
    public void init(Map<String, String> parameters) {
		_parameters = parameters;
    }
	
	@Override
	public CmisService getService(CallContext context) {
		
		if (_service == null ){
			try {
				_service = new NuxeoForwardingService();
				_service.init(_parameters);
			} catch (Exception e) {
	            throw new CmisRuntimeException("Could not create service instance: " + e, e);
	        }
		}
		_service.setCallContext(context);
		return _service;
	}	
}
