package it.unibo.cmdbuild.rest;

import it.unibo.cmdbuild.rest.Attribute.AttributeType;

public class AttributeValue {

	private Attribute schema;
	private String value;

	public AttributeValue(Attribute schema, String value) {
		this.schema = schema;
		this.value = value;
	}

	public Attribute getSchema() {
		return schema;
	}

	public String getValue() {
		if(schema.getType()==AttributeType.LOOKUP && value!=null && !value.isEmpty())
			return schema.getLookupType().getValue(getInt()).getCode();
		else
			return value;
	}

	public int getInt() {
		return value != null && !value.isEmpty() ? Integer.parseInt(value) : 0;
	}

	public boolean getBoolean() {
		return Boolean.parseBoolean(value);
	}
}
