package it.unibo.cmdbuild.rest;

import java.util.HashMap;
import java.util.Map;

import org.json.JSONException;
import org.json.JSONObject;

public abstract class Element {

	private Map<String, AttributeValue> values = new HashMap<String, AttributeValue>();
	private int id;
	private boolean isActive;
	private Schema schema;

	protected Element(JSONObject json, Schema schema) throws JSONException {
		this(json, schema, "Id");
	}

	protected Element(JSONObject json, Schema schema, String idProperty)
			throws JSONException {
		this.schema = schema;
		if (idProperty != null)
			this.id = json.getInt(idProperty);
		this.isActive = json.optBoolean("Active", true);
	}

	public void parseAttributes(JSONObject json) throws JSONException {
		if (json != null && schema != null) {
			AttributeMap attributes = schema.getAttributes();
			if (attributes != null) {
				for (Attribute attribute : attributes.values()) {
					AttributeValue value = attribute.parse(json);
					values.put(attribute.getName(), value);
				}
			}
		}
	}

	public CMDBuildClient getCMDB() {
		return schema.getCMDB();
	}

	public AttributeValue get(String name) {
		return values.get(name);
	}

	public boolean hasAttribute(String name) {
		boolean found = false;
		if(values.containsKey(name)) {
			AttributeValue attributeValue = values.get(name);
			if(attributeValue != null) {
				String value = attributeValue.getValue();
				found = value!=null && !value.isEmpty();
			}
		}
		return found;
	}

	public int getId() {
		return id;
	}

	public boolean isActive() {
		return isActive;
	}

	public Map<String, AttributeValue> getAttributeValueMap() {
		return values;
	}

	public Schema getSchema() {
		return this.schema;
	}
}
