package it.unibo.cmdbuild.rest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LookupType {
	private CMDBuildClient cmdb;
	private String type;
	private String parent;
	private Map<Integer, Lookup> values = new HashMap<Integer, Lookup>();

	public LookupType(JSONObject json, CMDBuildClient cmdb)
			throws JSONException {
		this.cmdb = cmdb;
		type = json.getString("description");
		parent = json.optString("parent", null);
	}
	
	public void parseInstances(JSONArray jsArray) throws JSONException {
		for (int i = 0; i < jsArray.length(); i++) {
			JSONObject jsItem = jsArray.getJSONObject(i);
			Lookup lookup = new Lookup(jsItem);
			assert (!values.containsKey(lookup.getId()));
			values.put(lookup.getId(), lookup);
		}
	}

	public Lookup getValue(int id) {
		return values.get(id);
	}

	public Collection<Lookup> values() {
		return values.values();
	}

	public String getType() {
		return type;
	}

	public LookupType getParentType() {
		return parent != null ? cmdb.getlookupType(parent) : null;
	}
}
