package it.unibo.cmdbuild.rest;

import java.util.Enumeration;
import java.util.Properties;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Schema {
	private CMDBuildClient cmdb;
	private String name;
	private boolean isActive;
	private int id;
	private AttributeMap attributes;
	private MetadataMap metadata;

	protected Schema(JSONObject json, CMDBuildClient cmdb) throws JSONException {
		this(json, cmdb, "id");
	}

	protected Schema(JSONObject json, CMDBuildClient cmdb, String idProperty)
			throws JSONException {
		this.cmdb = cmdb;
		if (idProperty != null)
			this.id = json.getInt(idProperty);
		this.name = json.getString("name");
		this.isActive = json.optBoolean("active", true);
		metadata = new MetadataMap(json.optJSONObject("meta"));
		Properties configuration = cmdb.getConfiguration();
		Enumeration<Object> configEnum = cmdb.getConfiguration().keys();
		String keyPrefix = "schema." + name + ".";
		while (configEnum.hasMoreElements()) {
			String key = (String) configEnum.nextElement();
			if (key.startsWith(keyPrefix))
				metadata.put(key.substring(keyPrefix.length()),
						(String) configuration.get(key));
		}

		if (json.has("attributes"))
			attributes = new AttributeMap(json.getJSONArray("attributes"), this);
	}

	public void parseAttributes(JSONArray jsArray) throws JSONException {
		AttributeMap attributes = new AttributeMap(jsArray, this);
		this.attributes = attributes;
	}

	public CMDBuildClient getCMDB() {
		return cmdb;
	}

	public String getName() {
		return name;
	}

	public boolean isActive() {
		return isActive;
	}

	protected String getJSONId() {
		return "id";
	}

	public int getId() {
		return id;
	}

	public AttributeMap getAttributes() {
		return attributes;
	}

	public MetadataMap getMetadata() {
		return metadata;
	}

	@Override
	public String toString() {
		return "[" + getName() + "]";
	}
}